<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>

<div class="business-tools-section">
    <div
        class="business-tools-row main-content"
        data-spy="scroll"
        data-target="#list-example"
        data-offset="20"
    >
        <div class="sidebar">
            <div class="list-group sidebar__inner" id="list-example">
                <div class="business-tools-img-list">
                    <img class="business-tools-img-bg" src="<?php echo esc_url($data['big_image']['url']); ?>" alt="image" />
                    <?php 
                        $i=1;
                        foreach ( $data['step_list'] as $item ){  
                    ?>   
                        <a href="#section<?php echo $i; ?>" class="business-tools-img list-group-item list-group-item-action">
                            <?php echo wp_get_attachment_image( $item['small_image']['id'], 'full' ); ?>
                        </a>
                
                    <?php $i++; } ?>
                </div>
            </div>
        </div>
        <div class="business-tools-content-scrolspy-section">
            <div
                class="business-tools-content-scrolspy scrollspy-example"
                data-bs-spy="scroll"
                data-bs-target="#list-example"
                data-bs-offset="0"
                tabindex="0"
            >
                <?php 
                    $i=1;
                    foreach ( $data['step_list'] as $item ){  
                ?>               
                <div class="business-tools-content" id="section<?php echo $i; ?>">
                    <?php if($item['title']){ ?>
                    <div class="section-title">
                        <span class="sub-title"><?php echo wp_kses_post($item['subtitle']) ?></span>
                        <h2 class="title mb-0"><?php echo wp_kses_post($item['title']) ?></h2>
                    </div>
                    <?php } ?>

                    <div class="business-tools-text pt-0">
                        <?php echo wp_kses_post($item['desc']) ?>
                        <?php if($item['ntn1'] || $item['ntn2'] || $item['ntn3']){ ?>
                        <div class="business-tools-btns">
                            <?php if($item['ntn1']){ ?>
                            <button>
                                <span class="iconify" data-icon="bi:check-lg"></span> <?php echo wp_kses_post($item['ntn1']) ?>
                            </button>
                            <?php } ?>
                            <?php if($item['ntn2']){ ?>
                            <button>
                                <span class="iconify" data-icon="bi:check-lg"></span> <?php echo wp_kses_post($item['ntn2']) ?>
                            </button>
                             <?php } ?>
                            <?php if($item['ntn3']){ ?>
                            <button>
                                <span class="iconify" data-icon="bi:check-lg"></span> <?php echo wp_kses_post($item['ntn3']) ?>
                            </button>
                             <?php } ?>
                        </div>
                         <?php } ?>
                    </div>
                </div>
                <?php $i++; } ?>
            </div>
        </div>
    </div>
</div>
<script>
    (function ($) {
    ("use strict");
        $(document).ready(function(){
            var sidebarSticky = $(".sidebar");
            if (sidebarSticky.length) {
                var sidebar = new StickySidebar(".sidebar", {
                    topSpacing: 20,
                    bottomSpacing: 20,
                    containerSelector: ".main-content",
                    innerWrapperSelector: ".sidebar__inner",
                });
            }
        });
     //activate plugin
   })(jQuery);
</script>


    




