<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>
<div class="row live-auctions-slider">
    <?php 
        foreach ( $data['step_list'] as $item ){  
    ?>
    <div class="col-md-12">
        <div class="nft-card">
            <div class="nft-card-timer">
                <ul class="timer_1">
                    <li class="hours">15<span>h</span></li>
                    <li class="minutes">50<span>m</span></li>
                    <li class="seconds">38<span>s</span></li>
                </ul>
                <p>Left</p>
            </div>
            <div class="nft-img">
                <?php echo wp_get_attachment_image( $item['big_image']['id'], 'full' ); ?>
            </div>
            <div class="nft-text">
                <div class="nft-owner">
                    <div class="nft-owner-img">
                       <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?>
                    </div>
                    <h6 class="wt-600 dm-sans"><?php echo wp_kses_post( $item['author'] ) ?> <?php echo wp_get_attachment_image( $item['check_img']['id'], 'full' ); ?></h6>
                </div>
                
                <h5 class="nft-title wt-700 dm-sans"><?php echo wp_kses_post( $item['title'] ) ?></h5>
                
                <p class="nft-value"><strong><?php echo wp_kses_post( $item['collections'] ) ?></strong> <span><?php echo wp_get_attachment_image( $item['arrow_icon']['id'], 'full' ); ?>0.82</span></p>
                <p class="card-bottom-text"><span>2 / 48</span> <span><span>&hearts;</span> &nbsp;124</span></p>
            </div>
        </div>
    </div>
    <?php } ?>
</div>




<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {

        var timer1 = $(".timer_1");
    if (timer1.length) {
        function makeTimer() {
            var endTime = new Date("aug 15, 2023 11:15:13");
            var endTime = (Date.parse(endTime)) / 1000;
            var now = new Date();
            var now = (Date.parse(now) / 1000);
            var timeLeft = endTime - now;
            var days = Math.floor(timeLeft / 86400);
            var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
            var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600)) / 60);
            var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));
            if (hours < "10") {
                hours = "0" + hours;
            }
            if (minutes < "10") {
                minutes = "0" + minutes;
            }
            if (seconds < "10") {
                seconds = "0" + seconds;
            }
            $(".timer_1 .hours").html(hours + "<span>H</span>");
            $(".timer_1 .minutes").html(minutes + "<span>M</span>");
            $(".timer_1 .seconds").html(seconds + "<span>S</span>");
        }
        setInterval(function () {
            makeTimer();
        }, 1000);
    }    
            
        var liveAuctionsSlider = $(".live-auctions-slider");
            if (liveAuctionsSlider.length) {
                $('.live-auctions-slider').slick({
                    dots: false,
                    infinite: true,
                    speed: 300,
                    slidesToShow: 4,
                    slidesToScroll: 1,
                    responsive: [
                        {
                            breakpoint: 1199,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 3,
                            }
                            },
                        {
                            breakpoint: 991,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1,
                            }
                            },
                        {
                            breakpoint: 575,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1
                            }
                            }
                        ]
                });
            }
        });
    })(jQuery);
</script>


