<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 * top_sub_title
 * title
 * subtitle
 * bg_title
 * top_title_icon
 *
 */
namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper; 
extract( $data );
$date = '';
if(!empty($data['countdown_time'])){
    $countdown_time  = strtotime( $data['countdown_time'] );
    $date = date('Y/m/d H:i:s', $countdown_time);
}

?>

<div class="banner_section_v2">
    <?php if ( $data['icon'] || $data['title'] || $data['title_color_txt'] ){ ?>
        <h2>
            <div class="item_icon mb-20"><?php echo $data['icon']; ?></div>
            <?php echo wp_kses_post( $data['title'] ); ?>
            <span class="color_txt"><?php echo wp_kses_post( $data['title_color_txt'] ); ?></span>
        </h2> 
    <?php } if ( $data['mint_count'] || $data['mint_count_text'] ){ ?>
        <h3>
            <span class="count"><?php echo wp_kses_post( $data['mint_count'] ); ?></span>
            <?php echo wp_kses_post( $data['mint_count_text'] ); ?>
        </h3>
    <?php } ?>
    <div class="banner_section_v2_contdown">
        <h4><?php echo wp_kses_post( $data['countdown_text'] ); ?></h4>
        <div class="countdown-wrapper">
            <div data-countdown="<?php echo esc_attr( $date ); ?>" class="staco-countdown"></div>
        </div>
    </div>
    <div class="staco_v1_baner_buttons">
        <div class="join_comunity_btns">
            <?php if ($data['btn1_link']) { ?>
            <a href="<?php echo esc_url( $data['btn1_link'] ); ?>" target="_blank"  class="site_btn colorPrimaryBg">
                <?php echo esc_html( $data['btn1_txt'] ); ?>
                <span class="hover_overlay"></span>
            </a>
            <?php } ?>
        </div>
    </div>
    <?php if ( $data['anim_img_list'] ){ ?>
        <div class="footer_stras_sect v2_baner_stars">
            <div class="footer_stars">
                <?php $i = 0; foreach ($data['anim_img_list'] as $list){ $i++; ?>
                    <span class="star_<?php echo $i; ?>"><?php echo wp_get_attachment_image( $list['anim_img']['id'], 'full' ); ?></span>
                <?php } ?>
            </div>
        </div>
    <?php } ?>
</div>