<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Banner3 extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Banner 3', 'staco-core' );
		$this->rt_base = 'staco-banner3';
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_script( 'jquery-countdown' );			
	}

	protected function register_controls() {

		/* = Banner 3 Options
		============================================*/
		$this->start_controls_section(
			'banner3_section',
			[
				'label' => esc_html__( 'Banner 3', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => esc_html__( 'Sub Title', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Whitelist :',
			]
		);
		$this->add_control(
			'subtitle_part2',
			[
				'label'       => esc_html__( 'Sub Title Part 2', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Soldout',
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Mint is live now',
			]
		);
		$this->add_control(
			'countdown_text',
			[
				'label'       => esc_html__( 'Countdown Text', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Public mint end in',
			]
		);
		$this->add_control(
			'countdown_time',
			[
				'label' => esc_html__( 'Countdown Time', 'staco-core' ),
				'type' => Controls_Manager::DATE_TIME,
			]
		);

		$this->add_control(
			'btntext',
			[
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Button Text', 'staco-core' ),
				'default' => 'LOREM IPSUM',
			]
		);

		$this->add_control(
			'btnurl',
			[
				'type'        => Controls_Manager::URL,
				'label'       => esc_html__( 'Button URL', 'staco-core' ),
				'placeholder' => 'https://your-link.com',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'banner_list_section',
			[
				'label' => __( 'Banner List', 'staco-core' ),
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_text', [
				'label'       => __( 'Title', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => 'List Text Goes Here',
				'label_block' => true,
			]
		);
		$this->add_control(
			'banner_list',
			[
				'label'       => __( 'List Items', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'list_text'    => 'Public mint 0.09 ETH + Gas',
					],
					[
						'list_text'    => 'Floor price 2.08 ETH',
					],
				],
				'title_field' => '{{{ list_text }}}',
			]
		);
		$this->end_controls_section();

		/* = Sub Title Settings
		==============================================================*/
		$this->start_controls_section(
			'subtitle_settings',
			[
				'label' => esc_html__( 'Sub Title Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v3 h4' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'subtitle_2_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color 2', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v3 h4 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}}  .banner_section_v3 h4',
			]
		);
		$this->end_controls_section();

		/* = Title Settings
		==============================================================*/
		$this->start_controls_section(
			'title_settings',
			[
				'label' => esc_html__( 'Title Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v3 h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .banner_section_v3 h2',
			]
		);
		$this->end_controls_section();

		/* = Mint Settings
		==============================================================*/
		$this->start_controls_section(
			'mint_settings',
			[
				'label' => esc_html__( 'Mint Count Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'mint_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v3_contdown h5' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'mint_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .banner_section_v3_contdown h5',
			]
		);
		$this->add_control(
			'mint_count_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Countdown Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v3_contdown h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'mint_count_typo',
				'label'    => esc_html__( 'Countdown Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .banner_section_v3_contdown h3',
			]
		);
		$this->end_controls_section();

		/* = Button Settings
		==============================================================*/
		$this->start_controls_section(
			'button_settings',
			[
				'label' => esc_html__( 'Button Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'btn_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Button Color', 'homlisti-core' ),
				'selectors' => [
					'{{WRAPPER}} .site_btn' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_background',
				'label' => esc_html__( 'Background', 'staco-core' ),
				'selector' => '{{WRAPPER}} .site_btn.colorPrimaryBg',
			]
		);
		$this->end_controls_section();

		/* = List Settings
		==============================================================*/
		$this->start_controls_section(
			'list_settings',
			[
				'label' => esc_html__( 'List Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'list_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v3 ul li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .banner_section_v3 ul li',
			]
		);
		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$this->rt_load_scripts();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}