<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Banner4 extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Banner 4', 'staco-core' );
		$this->rt_base = 'staco-banner4';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {

		/* = Banner 4 Options
		============================================*/
		$this->start_controls_section(
			'banner4_section',
			[
				'label' => esc_html__( 'Banner 4', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_part1',
			[
				'label'       => esc_html__( 'Title Part 1', 'staco-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default'     => 'The Cat',
			]
		);
		$this->add_control(
			'anim1_img',
			[
				'label'       => esc_html__( 'Animation 1 Image', 'staco-core' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'anim2_img',
			[
				'label'       => esc_html__( 'Animation 2 Image', 'staco-core' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'title_part2',
			[
				'label'       => esc_html__( 'Title Part 2', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'In metaverse',
			]
		);
		//Button 1
		$this->add_control(
			'btn1_txt',
			[
				'label'   => esc_html__( 'Button 1 Text', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => 'Mint Now',
			]
		);
		$this->add_control(
			'btn1_link',
			[
				'label'   => esc_html__( 'Button 1 Link', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '#',
			]
		);
		//Button 2
		$this->add_control(
			'btn2_txt',
			[
				'label'   => esc_html__( 'Button 2 Text', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => 'Wishlist Now',
			]
		);
		$this->add_control(
			'btn2_link',
			[
				'label'   => esc_html__( 'Button 2 Link', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => '#',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'banner_list_section',
			[
				'label' => __( 'Banner List', 'staco-core' ),
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_text', [
				'label'       => __( 'Title', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => 'List Text Goes Here',
				'label_block' => true,
			]
		);
		$this->add_control(
			'banner_list',
			[
				'label'       => __( 'List Items', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'list_text'    => 'Stage 2, Public Sale',
					],
					[
						'list_text'    => 'June 14 2022: 12:00pm est',
					],
				],
				'title_field' => '{{{ list_text }}}',
			]
		);
		$this->end_controls_section();

		/* = Title Settings
		==============================================================*/
		$this->start_controls_section(
			'title_settings',
			[
				'label' => esc_html__( 'Title Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v4 h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .banner_section_v4 h2',
			]
		);
		$this->end_controls_section();

		/* = Button Settings
		==============================================================*/
		$this->start_controls_section(
			'button_settings',
			[
				'label' => esc_html__( 'Button Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'btn1_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Button 1 Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .site_btn' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn2_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Button 2 Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .site_btn.btn-style-3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();

		/* = List Settings
		==============================================================*/
		$this->start_controls_section(
			'list_settings',
			[
				'label' => esc_html__( 'List Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'list_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v4 ul li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'list_color2',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color 2', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner_section_v4 ul li span' => 'color: {{VALUE}}',
				],
				'description' => __( 'Color 2 Work in span tag in li', 'homlisti-core' ),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .banner_section_v4 ul li',
			]
		);
		$this->end_controls_section();
    }

    private function rt_load_scripts(){
		wp_enqueue_script( 'fireflys' );	
	}

	protected function render() {
		$data     = $this->get_settings();
		$this->rt_load_scripts();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}