<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\Staco_Core;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class comparePrice extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Compare Price', 'staco-core' );
		$this->rt_base = 'staco-compare-price';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {

		$this->start_controls_section(
            '_section_basic',
            [
                'label' => esc_html__( 'Basic Price', 'staco' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'basic',
            [
                'label' => esc_html__( 'Basic', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Basic',
            ]
        );

         $this->add_control(
            'currency',
            [
                'label' => esc_html__( 'Currency', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '$', 'staco' ),
                'condition' => [
					'layout' => 'style3'
				],
            ]
        );

         $this->add_control(
            'price',
            [
                'label' => esc_html__( 'Price', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '29', 'staco' ),
            ]
        );

         $this->add_control(
            'per_year',
            [
                'label' => esc_html__( 'Per Year', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Per Year', 'staco' ),
            ]
        );

         $this->add_control(
            'user',
            [
                'label' => esc_html__( 'User', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '(For 15 User)', 'staco' ),
            ]
        );
        

        $this->add_control(
            'features',
            [
                'label'   => esc_html__( 'Features (Use List Style)', 'staco' ),
                'type'    => Controls_Manager::WYSIWYG,
                'rows'    => 10, 
                'default' => esc_html__( '1 Users', 'staco' ),          
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Text', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Start for free', 'staco' ),
                'placeholder' => esc_html__( 'Type button text here', 'staco' ),
                'label_block' => false,
            ]
        );

         $this->add_control(
            'button_link',
            [
                'label' => esc_html__( 'Button Link', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '#', 'staco' ),
                'placeholder' => esc_html__( 'https://example.com/', 'staco' ),
                'label_block' => false,
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
            '_section_premium',
            [
                'label' => esc_html__( 'Premium Price', 'staco' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'premium',
            [
                'label' => esc_html__( 'Premium', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Premium',
            ]
        );

         $this->add_control(
            'premium_currency',
            [
                'label' => esc_html__( 'Currency', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '$', 'staco' ),
                'condition' => [
					'layout' => 'style3'
				],
            ]
        );

         $this->add_control(
            'premium_price',
            [
                'label' => esc_html__( 'Price', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '39', 'staco' ),
            ]
        );

         $this->add_control(
            'premium_per_year',
            [
                'label' => esc_html__( 'Per Year', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Per Year', 'staco' ),
            ]
        );

         $this->add_control(
            'premium_user',
            [
                'label' => esc_html__( 'User', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '(For 15 User)', 'staco' ),
            ]
        );
        

        $this->add_control(
            'premium_features',
            [
                'label'   => esc_html__( 'Features (Use List Style)', 'staco' ),
                'type'    => Controls_Manager::WYSIWYG,
                'rows'    => 10, 
                'default' => esc_html__( '1 Users', 'staco' ),          
            ]
        );

        $this->add_control(
            'premium_button_text',
            [
                'label' => esc_html__( 'Button Text', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Start for free', 'staco' ),
                'placeholder' => esc_html__( 'Type button text here', 'staco' ),
                'label_block' => false,
            ]
        );

        $this->add_control(
            'premium_button_link',
            [
                'label' => esc_html__( 'Button Link', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '#', 'staco' ),
                'placeholder' => esc_html__( 'https://example.com/', 'staco' ),
                'label_block' => false,
            ]
        );

        $this->end_controls_section();


		$this->start_controls_section(
            '_section_professional',
            [
                'label' => esc_html__( 'Professional Price', 'staco' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'professional',
            [
                'label' => esc_html__( 'Professional', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Professional',
            ]
        );

         $this->add_control(
            'professional_currency',
            [
                'label' => esc_html__( 'Currency', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '$', 'staco' ),
                'condition' => [
					'layout' => 'style3'
				],
            ]
        );

         $this->add_control(
            'professional_price',
            [
                'label' => esc_html__( 'Price', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '49', 'staco' ),
            ]
        );

         $this->add_control(
            'professional_per_year',
            [
                'label' => esc_html__( 'Per Year', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Per Year', 'staco' ),
            ]
        );

         $this->add_control(
            'professional_user',
            [
                'label' => esc_html__( 'User', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '(For 15 User)', 'staco' ),
            ]
        );
        

        $this->add_control(
            'professional_features',
            [
                'label'   => esc_html__( 'Features (Use List Style)', 'staco' ),
                'type'    => Controls_Manager::WYSIWYG,
                'rows'    => 10, 
                'default' => esc_html__( '1 Users', 'staco' ),          
            ]
        );

        $this->add_control(
            'professional_button_text',
            [
                'label' => esc_html__( 'Button Text', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Start for free', 'staco' ),
                'placeholder' => esc_html__( 'Type button text here', 'staco' ),
                'label_block' => false,
            ]
        );

        $this->add_control(
            'professional_button_link',
            [
                'label' => esc_html__( 'Button Link', 'staco' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '#', 'staco' ),
                'placeholder' => esc_html__( 'https://example.com/', 'staco' ),
                'label_block' => false,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'vs_right_text',
            [
                'label' => esc_html__( 'VS Right Text', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
   
        $repeater = new Repeater();
        $repeater->add_control(
			'image_icon',
			[
				'label'   => __( 'Icon Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);


        $repeater->add_control(
            'features',
            [
                'label'   => esc_html__( 'Trilaa $580', 'rsaddon' ),
                'type'    => Controls_Manager::WYSIWYG,
                'rows'    => 10, 
                'default' => esc_html__( '1 Users', 'rsaddon' ),          
            ]
        );


        $this->add_control(
            'price_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ features }}}',
            ]
        ); 

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_style_general',
            [
                'label' => esc_html__( 'Item Style', 'staco' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background_color',
                'label' => esc_html__( 'Background', 'staco' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .compare-price-content .compare-price-card',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'general_box_shadow',
                'exclude' => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .compare-price-content .compare-price-card',
            ]
        );

        $this->add_responsive_control(
            'item_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'staco' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .compare-price-content .compare-price-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__( 'Padding', 'staco' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .compare-price-content .compare-price-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            '_section_style_header',
            [
                'label' => esc_html__( 'Header Style', 'staco' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'headtitle_color',
            [
                'label' => esc_html__( 'Title Color', 'staco' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .compare-price-content .compare-price-dropdown select option' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [   
                'label' => esc_html__( 'Title Typography', 'staco' ),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .compare-price-content .compare-price-dropdown select option',
            ]
        );

        $this->add_control(
            'price_color',
            [
                'label' => esc_html__( 'Price Color', 'staco' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .compare-price-content .compare-price-dropdown select option' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [   
                'label' => esc_html__( 'Price Typography', 'staco' ),
                'name' => 'price_typography',
                'selector' => '{{WRAPPER}} .compare-price-content .compare-price-dropdown select option',
            ]
        );

        $this->add_responsive_control(
            'title_paddings',
            [
                'label' => esc_html__( 'Padding', 'staco' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .compare-price-content .compare-price-dropdown select option' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_style_body',
            [
                'label' => esc_html__( 'Pricing Body Style', 'staco' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'des_list_color',
            [
                'label' => esc_html__( 'Description Color', 'staco' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .compare-price-content .compare-list ul li' => 'color: {{VALUE}}; opacity:1;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [   
                'label' => esc_html__( 'Description Typography', 'staco' ),
                'name' => 'des_typography',
                'selector' => '{{WRAPPER}} .compare-price-content .compare-list ul li',
            ]
        );

        $this->add_responsive_control(
            'body_padding',
            [
                'label' => esc_html__( 'Padding', 'staco' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .compare-price-content .compare-list ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            '_section_style_button',
            [
                'label' => esc_html__( 'Button Style', 'staco' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->start_controls_tabs( '_tabs_button' );

        $this->start_controls_tab(
            '_tab_button_normal',
            [
                'label' => esc_html__( 'Normal', 'staco' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => esc_html__( 'Text Color', 'staco' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bg-blue-btn' => 'color: {{VALUE}};',
                ],
            ]
        );
        

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background__sd',
                'label' => __( 'Background Color', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .bg-blue-btn',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .bg-blue-btn',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .bg-blue-btn',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'staco' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bg-blue-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .bg-blue-btn',
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label' => esc_html__( 'Margin', 'staco' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bg-blue-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__( 'Padding', 'staco' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .bg-blue-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );  

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_button_hover',
            [
                'label' => esc_html__( 'Hover', 'staco' ),
            ]
        );

        $this->add_control(
            'button_hover_color',
            [
                'label' => esc_html__( 'Text Color', 'staco' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bg-blue-btn' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_hover_border',
                'selector' => '{{WRAPPER}} .bg-blue-btn',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_hover_box_shadow',
                'selector' => '{{WRAPPER}} .bg-blue-btn',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_btn_hover',
                'label' => __( 'Background Color', 'plugin-domain' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .bg-blue-btn',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render() {
		$data = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}