<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
// namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper;  ?>

<div class="compare-price-content">
    <div class="compare-price-card">
        <div class="compare-price-dropdown">
            <form action="/" method="post">
                <select name="select-compare-price" id="select-compare-price">
                    <option value="basic"><?php echo wp_kses_post( $data['basic'] ); ?></option>
                    <option value="premium"><?php echo wp_kses_post( $data['premium'] ); ?></option>
                    <option value="professional"><?php echo wp_kses_post( $data['professional'] ); ?></option>
                </select>
            </form>
        </div> 

        <div class="basic-price">
            <h2 class="compare-price-title"><sup><?php echo wp_kses_post( $data['currency'] ); ?></sup><strong><?php echo wp_kses_post( $data['price'] ); ?></strong><?php echo wp_kses_post( $data['per_year'] ); ?> <span><?php echo wp_kses_post( $data['user'] ); ?></span>
            </h2>

            <div class="compare-list">
                <?php echo wp_kses_post( $data['features'] ); ?>
            </div>
            <a href="<?php echo esc_url( $data['button_link'] ); ?>" class="bg-blue-btn"><?php echo wp_kses_post( $data['button_text'] ); ?></a>
        </div>


        <div class="premium-price">
            <h2 class="compare-price-title"><sup><?php echo wp_kses_post( $data['premium_currency'] ); ?></sup><strong><?php echo wp_kses_post( $data['premium_price'] ); ?></strong><?php echo wp_kses_post( $data['premium_per_year'] ); ?> <span><?php echo wp_kses_post( $data['premium_user'] ); ?></span>
            </h2>

            <div class="compare-list">
                <?php echo wp_kses_post( $data['premium_features'] ); ?>
            </div>
            <a href="<?php echo esc_url( $data['premium_button_link'] ); ?>" class="bg-blue-btn"><?php echo wp_kses_post( $data['premium_button_text'] ); ?></a>
        </div>

        <div class="professional-price">
            <h2 class="compare-price-title"><sup><?php echo wp_kses_post( $data['professional_currency'] ); ?></sup><strong><?php echo wp_kses_post( $data['professional_price'] ); ?></strong><?php echo wp_kses_post( $data['professional_per_year'] ); ?> <span><?php echo wp_kses_post( $data['professional_user'] ); ?></span>
            </h2>
  
            <div class="compare-list">
                <?php echo wp_kses_post( $data['professional_features'] ); ?>
            </div>
            <a href="<?php echo esc_url( $data['professional_button_link'] ); ?>" class="bg-blue-btn"><?php echo wp_kses_post( $data['professional_button_text'] ); ?></a>
        </div>

    </div>
    <div class="vs">
        <h6><span><?php echo esc_html__('vs', 'staco');?></span></h6>
    </div>
    <div class="compare-price-card pt-0 pb-0">
        <div class="compare-price-list">
            <ul>
                <?php foreach ( $data['price_list'] as $items => $item ) {                            
                    $features       = !empty($item['features']) ? $item['features'] : '';                               
                    $image_icon     = !empty($item['image_icon']) ? $item['image_icon'] : ''; ?>
                    <li><span><?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?></span><?php echo wp_kses_post ($features);?></li>
                <?php } ?>    

            </ul>
        </div>
    </div>
</div>


<script>
    (function ($) {
    ("use strict");
    $(document).ready(function(){

    var comparePriceCard = $(".compare-price-card");
    if (comparePriceCard.length) {
        var selectComparePrice = comparePriceCard.find("#select-compare-price");
        var basicPrice = comparePriceCard.find(".basic-price");
        var premiumPrice = comparePriceCard.find(".premium-price");
        var professionalPrice = comparePriceCard.find(".professional-price");

        selectComparePrice.on("change", function () {
            var $option = $(this).find("option:selected");
            var value = $option.val();
            if (value == "basic") {
                basicPrice.css("display", "block");
                premiumPrice.css("display", "none");
                professionalPrice.css("display", "none");
            }
            else if (value == "premium") {
                basicPrice.css("display", "none");
                premiumPrice.css("display", "block");
                professionalPrice.css("display", "none");
            }
           else if (value == "professional") {
                basicPrice.css("display", "none");
                premiumPrice.css("display", "none");
                professionalPrice.css("display", "block");
            } else {
                basicPrice.css("display", "block");
                premiumPrice.css("display", "none");
                professionalPrice.css("display", "none");
            }
        });
    }

    });
    /*-- Testimonial slider scripts end --*/
   })(jQuery);
</script>















