<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core; ?>

<div class="header-top-timer">
    <ul class="timer">
        <li class="days"><?php echo esc_html('100', 'staco');?> <span><?php echo esc_html('d', 'staco');?></span></li>
        <li class="hours"><?php echo esc_html('22', 'staco');?> <span><?php echo esc_html('h', 'staco');?></span></li>
        <li class="minutes"><?php echo esc_html('55', 'staco');?> <span><?php echo esc_html('m', 'staco');?></span></li>
        <li class="seconds"><?php echo esc_html('08', 'staco');?> <span><?php echo esc_html('s', 'staco');?></span></li>
    </ul>
</div>

<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            var timerContent = $(".timer");
            if (timerContent.length) {
                function makeTimer() {
                    var endTime = new Date("<?php echo wp_kses_post($data['sec_day']); ?> <?php echo wp_kses_post($data['sec_month']); ?>, <?php echo wp_kses_post($data['sec_year']); ?> 02:15:13");
                    var endTime = Date.parse(endTime) / 1000;
                    var now = new Date();
                    var now = Date.parse(now) / 1000;
                    var timeLeft = endTime - now;
                    var days = Math.floor(timeLeft / 86400);
                    var hours = Math.floor((timeLeft - days * 86400) / 3600);
                    var Xmas95 = new Date("Feb 25, 2022 23:15:30");
                    var hour = Xmas95.getHours();
                    var minutes = Math.floor((timeLeft - days * 86400 - hours * 3600) / 60);
                    var seconds = Math.floor(timeLeft - days * 86400 - hours * 3600 - minutes * 60);
                    if (hours < "10") {
                        hours = "0" + hours;
                    }
                    if (minutes < "10") {
                        minutes = "0" + minutes;
                    }
                    if (seconds < "10") {
                        seconds = "0" + seconds;
                    }
                    $(".timer .days").html(days + "<span>d</span>");
                    $(".timer .hours").html(hours + "<span>h</span>");
                    $(".timer .minutes").html(minutes + "<span>m</span>");
                    $(".timer .seconds").html(seconds + "<span>s</span>");
                }
                setInterval(function () {
                    makeTimer();
                }, 1000);
            }
        });
    })(jQuery);
</script>

