<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;

class StacoCounter extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Staco Counter', 'staco-core' );
		$this->rt_base = 'staco-counter';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {
		$this->start_controls_section(
			'sec_general',
			[
				'label' => __( 'Counter', 'staco-core' ),
			]
		);

		$this->add_control(
			'number_prefix', [
				'label'       => __( 'Number Prefix', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true
			]
		);

		$this->add_control(
			'number', [
				'label'       => __( 'Number', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => '200',
				'label_block' => true
			]
		);
		
		$this->add_control(
			'number_suffix', [
				'label'       => __( 'Number Suffix', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => 'K',
				'label_block' => true
			]
		);

		$this->add_control(
			'title', [
				'label'       => __( 'Title', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => 'Counter Title',
				'label_block' => true
			]
		);
		$this->end_controls_section();


		/* = Sub Title Settings
		==============================================================*/
		$this->start_controls_section(
			'sec_subtitle_settings',
			[
				'label' => esc_html__( 'Style Area', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'number_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Number Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .statistics-text h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'number_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .statistics-text h2',
			]
		);

		$this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Title Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .statistics-text p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .statistics-text p',
			]
		);


		$this->end_controls_section();
	}

	protected function render() {
		$data = $this->get_settings();
		$template = 'view-1';
		$this->rt_template( $template, $data );
	}
}