<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Faq extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Faq', 'staco-core' );
		$this->rt_base = 'staco-faq';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {

		/* = Faq Options
		============================================*/
		$this->start_controls_section(
			'faq_list_section',
			[
				'label' => __( 'Faq List', 'staco-core' ),
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'title', [
				'label' => __( 'Title', 'evacon-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'accodion_text', [
				'label' => __( 'Content', 'evacon-core' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'List Content' , 'evacon-core' ),
				'show_label' => false,
			]
		);
		$this->add_control(
			'faq_list',
			[
				'label'       => __( 'Faq Items', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'title'    => 'What is MiNFT ?',
						'accodion_text' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. ',
					],
					[
						'title'    => 'How we can buy and invest NFT ?',
						'accodion_text' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. ',
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);
		$this->add_control(
			'icon_display',
			[
				'label' => esc_html__( 'Show Icon', 'staco-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'staco-core' ),
				'label_off' => esc_html__( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'icon_position',
			[
				'type'    => Controls_Manager::CHOOSE,
				'label'   => esc_html__( 'Icon Position', 'evacon-core' ),
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'evacon-core' ),
						'icon' => 'eicon-h-align-left',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'evacon-core' ),
						'icon' => 'eicon-h-align-right',
					],		     
				],
				'default' => 'right',
				'label_block' => false,
				'toggle' => false,
				'condition'   => [ 'icon_display!' => ''],
			]
		);
		$this->add_control(
			'faq_anim',
			[
				'label'        => __( 'Animation', 'staco-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Yes', 'staco-core' ),
				'label_off'    => __( 'No', 'staco-core' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->end_controls_section();

		/* = Title Settings
		==============================================================*/
		$this->start_controls_section(
			'title_settings',
			[
				'label' => esc_html__( 'Title Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .faq-box .panel-heading .accordion-button' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .faq-box .panel-heading .accordion-button',
			]
		);
		$this->end_controls_section();

		/* = Text Settings
		==============================================================*/
		$this->start_controls_section(
			'text_settings',
			[
				'label' => esc_html__( 'Text Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'text_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .faq-box .panel-body' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'text_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}}  .faq-box .panel-body',
			]
		);
		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}