<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
// namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper; 

global $staco_id;
$staco_id = empty($staco_id) ? 1 : $staco_id + 1;
$accordian_id = 'rtaccordion-'.$staco_id;
if ( $data['icon_display']  == 'yes' ) {
    $icon = $data['icon_position'];
} else {
    $icon = '';
}


$anim = $data['faq_anim'];
if ($anim) {
    $anim_class = 'wow fadeInUp';
} else {
    $anim_class = '';
}

?>

<div class="accordion theme-accordion" id="<?php echo esc_attr( $accordian_id ) ?>">
    <?php $i = 1;
        foreach ( $data['faq_list'] as $accordion ) {
        $show =  $i == 1 ? 'show' : '';
        $collapsed =  $i == 1 ? '' : 'collapsed';
        $t = $accordion['title'];
        $uid = strtolower(str_replace(array(':', '\\', '/', '*', '?', '.', ';', ' '), '', $t));
        $unique = rand(2012,35120);
    ?>
    <div class="accordion-item">
        <h2 class="accordion-header" id="heading<?php echo esc_attr($unique); ?>">
        <button class="accordion-button <?php echo esc_attr($collapsed); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo esc_attr($unique); ?>" aria-expanded="true" aria-controls="collapse<?php echo esc_attr($unique); ?>">
            <?php if ( $data['icon_display']  == 'yes' ) { ?>
                <span class="rtin-accordion-icon">
                    <span class="rtin-icon rt-icon-closed">
                        <img src="<?php echo Helper::get_img('accordion-plus.png') ?>" alt="<?php echo esc_attr( 'Close Icon', 'staco-core' ); ?>">
                    </span>
                    <span class="rtin-icon rt-icon-opened">
                        <img src="<?php echo Helper::get_img('accordion-minus.png') ?>" alt="<?php echo esc_attr( 'Open Icon', 'staco-core' ); ?>">
                    </span>
                </span>
            <?php } ?>
            <?php echo wp_kses_post( $accordion['title'] ); ?>
        </button>
        </h2>
        <div id="collapse<?php echo esc_attr($unique); ?>" class="accordion-collapse collapse" aria-labelledby="heading<?php echo esc_attr($unique); ?>" data-bs-parent="#<?php echo esc_attr( $accordian_id ) ?>">
        <div class="accordion-body">
            <p>
            <?php echo wp_kses_post( $accordion['accodion_text'] ) ?>
            </p>
        </div>
        </div>
    </div>
    <?php $i++; } ?>
</div>