<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class globeImg extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Globe Image', 'staco-core' );
		$this->rt_base = 'globe-img';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__('Globe Image', 'staco-core'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'image_icon',
			[
				'label' => esc_html__('Globe Image', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'shape_img1',
			[
				'label' => esc_html__('Shape Image 1', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'shape_img2',
			[
				'label' => esc_html__('Shape Image 2', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'shape_img3',
			[
				'label' => esc_html__('Shape Image 3', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'shape_img4',
			[
				'label' => esc_html__('Shape Image 4', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}