<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>
<div class="ecosystem-content">
    <div class="globe-img">
        <?php if($data['image_icon']['url']){ ?>
        <img src="<?php echo esc_url($data['image_icon']['url']); ?>" alt="img" class="globe" />
        <?php } ?>
        <?php if($data['shape_img1']['url']){ ?>
        <img src="<?php echo esc_url($data['shape_img1']['url']); ?>" alt="img" class="cloud1" />
        <?php } ?>
        <?php if($data['shape_img2']['url']){ ?>
        <img src="<?php echo esc_url($data['shape_img2']['url']); ?>" alt="img" class="cloud2" />
        <?php } ?>
        <?php if($data['shape_img3']['url']){ ?>
        <img src="<?php echo esc_url($data['shape_img3']['url']); ?>" alt="img" class="cloud3" />
        <?php } ?>
        <?php if($data['shape_img4']['url']){ ?>
        <img src="<?php echo esc_url($data['shape_img4']['url']); ?>" alt="img" class="cloud4" />
        <?php } ?>
    </div>
</div>
<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            var cloud3 = $(".cloud3");
            if (cloud3.length) {
                $(window).on("scroll", function () {
                    var cloud3 = $(".cloud3");
                    var y = window.scrollY;
                    var x;
                    x = cloud3.offset().top;
                    x = x - 400;

                    let animationValue = 1;
                    animationValue = (-1 * (y - x)) / 9;

                    let animationStop = 100;

                    if (animationValue < 0) {
                        animationValue > 0;
                    }

                    if (animationValue > animationStop) {
                        animationValue = animationStop;
                    }

                    cloud3.css("transform", `translateX(${animationValue}px)`);
                });
            }

            var cloud2 = $(".cloud2");
            if (cloud2.length) {
                $(window).on("scroll", function () {
                    var cloud2 = $(".cloud2");
                    var y = window.scrollY;
                    var x;
                    x = cloud2.offset().top;
                    x = x - 400;

                    let animationValue = 1;
                    animationValue = (y - x) / 9;

                    let animationStop = 100;

                    if (animationValue < 0) {
                        animationValue > 0;
                    }

                    if (animationValue > animationStop) {
                        animationValue = animationStop;
                    }

                    cloud2.css("transform", `translateX(${animationValue}px)`);
                });
            }
            var globe = $(".globe");
            if (globe.length) {
                $(window).on("scroll", function () {
                    var globe = $(".globe");
                    var y = window.scrollY;
                    var x;
                    x = globe.offset().top;
                    x = x - 400;

                    let animationValue = 1;
                    animationValue = (y - x) / 9;

                    let animationStop = 100;

                    if (animationValue < 0) {
                        animationValue > 0;
                    }

                    if (animationValue > animationStop) {
                        animationValue = animationStop;
                    }

                    globe.css("transform", `rotate(${animationValue}deg)`);
                });
            }
        })
    })(jQuery);
</script>



