<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class mintSteps extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Mint Step', 'staco-core' );
		$this->rt_base = 'staco-mint-step';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'sec_mint_step',
			[
				'label' => esc_html__( 'Mint Step', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'stroke',
			[
				'label'       => esc_html__( 'Stroke Text', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => "1",
				'label_block' => true,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'staco-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => 'Connect Your Wallet',
				'label_block' => true,
			]
		);
		$this->end_controls_section();


		/* = Stroke Settings
		==============================================================*/
		$this->start_controls_section(
			'stroke_settings',
			[
				'label' => esc_html__( 'Stroke Text Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'stroke_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .mint_step h2' => '-webkit-text-stroke: 1px {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'stroke_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .mint_step h2',
			]
		);
		$this->add_responsive_control(
			'stroke_margin',
			[
				'label'        => __( 'Margin', 'staco-core' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px' ],
				'default'      => [
					'top'      => '',
					'right'    => '',
					'bottom'   => '',
					'left'     => '',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .mint_step h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		$this->end_controls_section();

		/* = Title Settings
		==============================================================*/
		$this->start_controls_section(
			'sec_title_settings',
			[
				'label' => esc_html__( 'Title Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .mint_step h4' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .mint_step h4',
			]
		);
		$this->add_responsive_control(
			'title_margin',
			[
				'label'        => __( 'Margin', 'staco-core' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px' ],
				'default'      => [
					'top'      => '',
					'right'    => '',
					'bottom'   => '',
					'left'     => '',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .mint_step h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);
		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view-1';
		$this->rt_template( $template, $data );
	}

}