<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\Staco_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class NftGallery extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Staco Gallery', 'staco-core' );
		$this->rt_base = 'staco-nft-gallery';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {

		//NFT Gallery Section
		$this->start_controls_section(
			'nft_gallery_section',
			[
				'label' => esc_html__( 'Staco Gallery', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'nft_img', [
				'label'       => __( 'Image', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'layout',
			[
				'label' => __('Layout Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Grid Gallery', 'staco-core' ),
					'style2' => __( 'Moving Gallery', 'staco-core' ),
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'moving',
			[
				'label' => __('Moving Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => __( 'Moving to left', 'staco-core' ),
					'2' => __( 'Moving to right', 'staco-core' ),
				],
				'label_block' => true,
				'condition'      => ['layout' => ['style2']],
			]
		);
		$this->add_control(
			'nft_img_list',
			[
				'label'       => __( 'Nft Image Items', 'staco-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

		/* = Box Settings
		==============================================================*/
		$this->start_controls_section(
			'gallery_image_settings',
			[
				'label' => esc_html__( 'Grid Gallery Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'grid_gallery_background',
				'label' => esc_html__( 'Background', 'staco-core' ),
				'selector' => '{{WRAPPER}} .image_box_v1',
			]
		);
		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view-1';
		if ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		}
		$this->rt_template( $template, $data );
	}

}