<?php
/**
 * This file can be overridden by copying it to yourtheme/elementor-custom/posts/view-1.php
 * 
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper; 

extract( $data );

$cols = $gird_column;
$excerpt = $content_limit;
$padmin = $post_admin;
$pdate = $post_date;
$pcats = $post_cat;
$pcomnt = $post_comm;
$more = $more_btn;

$grid_query= null;
if ( $query_type == 'cats' && !empty( $postbycats ) ) {
    $args = array(
        'post_type'      => 'post',
        'post_status'    => 'publish',
        'posts_per_page' => $post_limit,
        'orderby'        => $orderby,
        'order'        	 => $order,
        'tax_query' => array(
            array(
                'taxonomy' => 'category',
                'field' => 'id',
                'terms' => $postbycats
            )
        ),
    );
} elseif ( $query_type == 'titles' && !empty( $postbytitle ) ) {
    $args = array(
        'post_type'      => 'post',
        'post_status'    => 'publish',
        'posts_per_page' => $post_limit,
        'orderby'        => $orderby,
        'order'        	 => $order,
        'taxonomy'       => 'category',
        'post__in'       => $postbytitle
    );
} else {
    $args = array(
        'post_type'      => 'post',
        'post_status'    => 'publish',
        'posts_per_page' => $post_limit,
        'orderby'        => $orderby,
        'order'        	 => $order,
        'offset'         => $offset,
        'taxonomy'       => 'category'
    );
}

$grid_query = new \WP_Query( $args );

if ( $grid_query->have_posts() ): 

?>
<div class="blog-post-content">
    <div class="row row-cols-lg-<?php echo esc_attr( $cols ); ?> row-cols-sm-2 row-cols-1">
        <?php 
            $i = 1;
            while ( $grid_query->have_posts() ) : $grid_query->the_post(); 
            $post_id = get_the_ID();
            $post_admin     = get_the_author();

            $comments_number = get_comments_number($post_id);
            $comments_text   = sprintf( _n( '%s', '%s', $comments_number, 'staco' ), number_format_i18n( $comments_number ) );
            if ( has_post_thumbnail() ){
                $thumb_img = '';
            } else {
                $thumb_img = 'no-image';
            }
            $imgurl=" ";
            if($i==2){
                  $imgurl = !empty($data['blog_image']['url']) ? 'style = background-image:url('.$data['blog_image']['url'].')' : '';
            }
        ?>
        <div class="col-lg-4 col-md-6 pb-4">
            <div class="blog-post-card blog-post-card<?php echo $i; ?>" <?php echo $imgurl;?>>
                <div class="card-title">
                    <div class="admin"><?php the_category(); ?></div>
                    <h4>
                        <a href="<?php the_permalink(); ?>"><?php echo the_title(); ?></a>
                    </h4>
                </div>
                <?php if($i!=2){ ?>
                    <p><?php echo helper::staco_excerpt( $excerpt ); ?></p>
                <?php } ?>
                <div class="card-footer">
                    <a href="<?php the_permalink(); ?>" class="user">
                        <div class="user-img">
                            <?php echo get_avatar( get_the_author_meta( 'ID' ), 32 ); ?>
                        </div>
                        <span class="admin"><?php echo esc_html($post_admin); ?></span>
                    </a>
                    <span><?php echo get_the_date(); ?></span>
                </div>
            </div>
        </div>
        <?php $i++; endwhile; wp_reset_postdata(); ?> 
    </div>
</div>
<?php endif; ?>