<?php
/**
 * This file can be overridden by copying it to yourtheme/elementor-custom/posts/view-1.php
 * 
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper; 

extract( $data );

$excerpt = $content_limit;
$padmin = $post_admin;
$pdate = $post_date;
$pcats = $post_cat;
$pcomnt = $post_comm;
$more = $more_btn;

$grid_query= null;
if ( $query_type == 'cats' && !empty( $postbycats ) ) {
    $args = array(
        'post_type'      => 'post',
        'post_status'    => 'publish',
        'posts_per_page' => $post_limit,
        'orderby'        => $orderby,
        'order'        	 => $order,
        'tax_query' => array(
            array(
                'taxonomy' => 'category',
                'field' => 'id',
                'terms' => $postbycats
            )
        ),
    );
} elseif ( $query_type == 'titles' && !empty( $postbytitle ) ) {
    $args = array(
        'post_type'      => 'post',
        'post_status'    => 'publish',
        'posts_per_page' => $post_limit,
        'orderby'        => $orderby,
        'order'        	 => $order,
        'taxonomy'       => 'category',
        'post__in'       => $postbytitle
    );
} else {
    $args = array(
        'post_type'      => 'post',
        'post_status'    => 'publish',
        'posts_per_page' => $post_limit,
        'orderby'        => $orderby,
        'order'        	 => $order,
        'offset'         => $offset,
        'taxonomy'       => 'category'
    );
}
$grid_query = new \WP_Query( $args );
if ( $grid_query->have_posts() ): ?>


<div class="news-content">
    <?php 
        $i = 1;
        while ( $grid_query->have_posts() ) : $grid_query->the_post(); 
        $post_id = get_the_ID();
        $post_admin     = get_the_author();

        $comments_number = get_comments_number($post_id);
        $comments_text   = sprintf( _n( '%s', '%s', $comments_number, 'staco' ), number_format_i18n( $comments_number ) );
        $blog_date      = get_the_date('d M y');	
        $imgurl = get_the_post_thumbnail_url(get_the_ID(),'full');
        if(!empty($imgurl)){
             $postimgurl = !empty($imgurl) ? 'style = background:url('.$imgurl.')' : '';
        }

       
    ?>
    <div class="news-row-section">
        <div class="container">
            <div class="news-row">
                <a href="<?php the_permalink(); ?>" class="news-link">
                    <h5><?php echo $blog_date; ?></h5>
                    <h3 data-splitting><?php echo the_title(); ?></h3>
                    <?php if(!empty($data['arrow_icon']['url'])){ ?>
                    <div class="link">
                        <a href="<?php the_permalink(); ?>" target="_blank" class="link-inner">
                            <span><img src="<?php echo esc_url($data['arrow_icon']['url']); ?>" alt="icon" /></span>
                            <span><img src="<?php echo esc_url($data['arrow_icon']['url']); ?>" alt="icon" /></span>
                        </a>
                    </div>
                    <?php } ?>

                </a>
                <div class="news-row-bg news1">
                    <div class="overlay" <?php echo $postimgurl; ?>></div>
                </div>
            </div>
        </div>
    </div>
    <?php $i++; endwhile; wp_reset_postdata(); ?>
</div>
<?php endif; ?>
