<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

?>

<!-- pricing sections start -->
<section class="pricing-section equal_height_<?php echo esc_attr($data['equal_height']);?>">
    <div class="pricing-selector">
        <form action="/" method="post">
            <button type="button" class="pricing-monthly-btn"><?php echo wp_kses_post($data['monthly_title']);?></button>
            <input type="checkbox" name="pricing-selector" id="pricing-selector">
            <button type="button" class="pricing-yearly-btn"><?php echo wp_kses_post($data['yearly_title']);?> <span><?php echo wp_kses_post($data['yearly_discount']);?></span></button>
        </form>
    </div>
    <div class="row">
      <div class="col-md-12">
        <div class="pricing-content">
          <div class="pricing-monthly">
            <div class="row">
              <?php
                  $i = 1;
                  foreach ( $data['price_list'] as $items => $item ) { 
                    $title                  = !empty($item['title']) ? $item['title'] : '';                          
                    $price                  = !empty($item['price']) ? $item['price'] : '';                            
                    $price_subtitle          = !empty($item['price_subtitle']) ? $item['price_subtitle'] : '';                            
                    $description            = !empty($item['description']) ? $item['description'] : '';                            
                    $features               = !empty($item['features']) ? $item['features'] : '';                            
                    $button_text            = !empty($item['button_text']) ? $item['button_text'] : '';                            
                    $image_icon             = !empty($item['image_icon']) ? $item['image_icon'] : '';                            
                    $custom_icon             = !empty($item['custom_icon']) ? $item['custom_icon'] : '';                            
                    $target                 = !empty($item['button_link']['is_external']) ? 'target=_blank' : '';  
                    $button_link            = !empty($item['button_link']['url']) ? $item['button_link']['url'] : '';
                    $title_yearly           = !empty($item['title_yearly']) ? $item['title_yearly'] : '';                    
                    $most_popular          = !empty($item['most_popular']) ? $item['most_popular'] : '';                            
                    $monthly_title          = !empty($item['monthly_title']) ? $item['monthly_title'] : '';                            
                    $price_yearly           = !empty($item['price_yearly']) ? $item['price_yearly'] : '';                            
                    $description_yearly     = !empty($item['description_yearly']) ? $item['description_yearly'] : '';
                    $features_yearly        = !empty($item['features_yearly']) ? $item['features_yearly'] : '';                            
                    $button_text_yearly     = !empty($item['button_text_yearly']) ? $item['button_text_yearly'] : '';       
                    $target                 = !empty($item['button_link_yearly']['is_external']) ? 'target=_blank' : '';  
                    $button_link_yearly     = !empty($item['button_link_yearly']['url']) ? $item['button_link_yearly']['url'] : '';
                    $active_switcher     = !empty($item['active_switcher']) ? $item['active_switcher'] : '';       
              ?>    
              <div class="col-lg-<?php echo esc_attr($data['column_row']);?> col-md-6 price_list<?php echo $i; ?> <?php echo esc_attr($item['active_switcher']);?>">
                <div class="pricing-card">
                  <div class="pricing-card-header">

                    <?php if ( 'top' == $data['icon_postion'] ) { ?>
                      <div class="card-header d-flex justify-content-between">       
                          <p><?php echo wp_kses_post ($description);?></p>
                          <div class="pricing-icon">
                              <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?>
                          </div>
                      </div>
                      <div class="custom-icon">
                            <?php echo wp_get_attachment_image( $item['custom_icon']['id'], 'full' ); ?>
                      </div>
                    <?php } ?> 


                    <div class="pricing-card-title">
                      <h2>
                          <span class="title"> <?php echo wp_kses_post ($title);?></span>
                          <?php if( !empty($most_popular)){ ?><span class="popular"><?php echo wp_kses_post ($most_popular);?></span><?php } ?>
                      </h2>
                        <?php if ( 'bottom' == $data['icon_postion'] ) { ?>    
                          <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?>
                        <?php } ?> 
                    </div>



                    <?php if ( 'bottom' == $data['icon_postion'] ) { ?>    
                        <p><?php echo wp_kses_post ($description);?></p>
                    <?php } ?>     

                    <h3><?php echo wp_kses_post ($price);?> <span class="month"><?php echo wp_kses_post ($monthly_title);?></span></h3>
                    <?php if(!empty($price_subtitle)){ ?>
                      <div class="price-subtitle"><?php echo wp_kses_post ($price_subtitle);?></div>
                    <?php } ?>

                  </div>

                  <?php if ( 'top' == $data['button_position'] ) { ?>    
                      <div class="sc-price-btn">
                          <a href="#" class="best-pricing-btn">
                              <?php echo wp_kses_post ($button_text);?> <span class="iconify" data-icon="akar-icons:arrow-right"></span>
                          </a>
                      </div>
                  <?php } ?>
                      
                  <div class="pricing-card-body">
                    <p><?php echo wp_kses_post ($features);?></p>
                    <?php 
                      if ( 'bottom' == $data['button_position'] ) { ?>
                      <?php 
                          if ( 'btn_icon' == $data['button_style'] ) { ?>
                          <a class="pricing-btn" href="<?php echo esc_attr ($button_link);?>">
                              <span class="iconify" data-icon="akar-icons:arrow-right"></span>
                          </a>
                          <?php } else{ ?>
                          <a href="<?php echo esc_attr ($button_link);?>" class="bg-blue-btn">
                              <span class="btn-inner">
                                  <span class="btn-normal-text"><?php echo wp_kses_post ($button_text_yearly);?></span>
                                  <span class="btn-hover-text"><?php echo wp_kses_post ($button_text_yearly);?></span>
                              </span>
                          </a>
                          <?php } ?>
                      <?php } ?>
                  </div>
                </div>
              </div>
              <?php $i++; } ?>


            </div>
          </div>
          <div class="pricing-yearly">
            <div class="row">
              <?php  
              $i = 1;
              foreach ( $data['price_list'] as $items => $item ) { 
                  $title                  = !empty($item['title']) ? $item['title'] : '';                            
                  $price                  = !empty($item['price']) ? $item['price'] : '';                            
                  $price_subtitle_yearly                  = !empty($item['price']) ? $item['price_subtitle_yearly'] : '';                            
                  $description            = !empty($item['description']) ? $item['description'] : '';                            
                  $features               = !empty($item['features']) ? $item['features'] : '';                            
                  $button_text            = !empty($item['button_text']) ? $item['button_text'] : '';                            
                  $image_icon_yearly      = !empty($item['image_icon_yearly']) ? $item['image_icon_yearly'] : '';                            
                  $custom_icon_yearly      = !empty($item['custom_icon_yearly']) ? $item['custom_icon_yearly'] : '';   
                  $most_popular          = !empty($item['most_popular']) ? $item['most_popular'] : '';                            
                  $target                 = !empty($item['button_link']['is_external']) ? 'target=_blank' : '';  
                  $button_link            = !empty($item['button_link']['url']) ? $item['button_link']['url'] : '';
                  $title_yearly           = !empty($item['title_yearly']) ? $item['title_yearly'] : '';                            
                  $price_yearly           = !empty($item['price_yearly']) ? $item['price_yearly'] : '';                              
                  $yearly_title           = !empty($item['yearly_title']) ? $item['yearly_title'] : '';                            
                  $description_yearly     = !empty($item['description_yearly']) ? $item['description_yearly'] : '';
                  $features_yearly        = !empty($item['features_yearly']) ? $item['features_yearly'] : '';                            
                  $button_text_yearly     = !empty($item['button_text_yearly']) ? $item['button_text_yearly'] : '';       
                  $active_switcher     = !empty($item['active_switcher']) ? $item['active_switcher'] : '';       
                  $target                 = !empty($item['button_link_yearly']['is_external']) ? 'target=_blank' : '';  
                  $button_link_yearly     = !empty($item['button_link_yearly']['url']) ? $item['button_link_yearly']['url'] : '';
              ?>  
              <div class="col-lg-<?php echo esc_attr($data['column_row']);?> col-md-6 price_list<?php echo $i; ?> <?php echo esc_attr($item['active_switcher']);?>" >
                <div class="pricing-card">
                  <div class="pricing-card-header">

                    <?php if ( 'top' == $data['icon_postion'] ) { ?> 
                      <div class="card-header d-flex justify-content-between">   
                            <p><?php echo wp_kses_post ($description_yearly);?></p>
                            <div class="pricing-icon">
                              <?php echo wp_get_attachment_image( $item['image_icon_yearly']['id'], 'full' ); ?>
                          </div>
                      </div>
                      <div class="custom-icon">
                            <?php echo wp_get_attachment_image( $item['custom_icon_yearly']['id'], 'full' ); ?>
                      </div>
                    <?php } ?> 
                    <div class="pricing-card-title">
                      <h2>
                          <span class="title"> <?php echo wp_kses_post ($title_yearly);?></span>
                          <?php if( !empty($most_popular)){ ?><span class="popular"><?php echo wp_kses_post ($most_popular);?></span><?php } ?>
                      </h2>
                      <?php if ( 'bottom' == $data['icon_postion'] ) { ?>  
                        <?php echo wp_get_attachment_image( $item['image_icon_yearly']['id'], 'full' ); ?>
                      <?php } ?> 
                    </div>

                    <?php if ( 'bottom' == $data['icon_postion'] ) { ?>    
                        <p><?php echo wp_kses_post ($description_yearly);?></p>
                    <?php } ?> 

                    <h3><?php echo esc_attr ($price_yearly);?> <span><?php echo wp_kses_post ($yearly_title);?></span></h3>
                    
                      <?php if(!empty($price_subtitle_yearly)){ ?>
                      <div class="price-subtitle"><?php echo wp_kses_post ($price_subtitle_yearly);?></div>
                    <?php } ?>

                  </div>
                  <?php if ( 'top' == $data['button_position'] ) { ?>    
                      <div class="sc-price-btn">
                          <a href="#" class="best-pricing-btn">
                              <?php echo wp_kses_post ($button_text_yearly);?> <span class="iconify" data-icon="akar-icons:arrow-right"></span>
                          </a>
                      </div>
                  <?php } ?>
                  <div class="pricing-card-body">
                    <p><?php echo wp_kses_post ($features_yearly);?></p> 

                      <?php 
                      if ( 'bottom' == $data['button_position'] ) { ?>
                      <?php 
                          if ( 'btn_icon' == $data['button_style'] ) { ?>
                          <a class="pricing-btn" href="<?php echo esc_attr ($button_link_yearly);?>">
                              <span class="iconify" data-icon="akar-icons:arrow-right"></span>
                          </a>
                          <?php } else{ ?>
                          <a href="<?php echo esc_attr ($button_link);?>" class="bg-blue-btn">
                              <span class="btn-inner">
                                  <span class="btn-normal-text"><?php echo wp_kses_post ($button_text_yearly);?></span>
                                  <span class="btn-hover-text"><?php echo wp_kses_post ($button_text_yearly);?></span>
                              </span>
                          </a>
                          <?php } ?>
                      <?php } ?>

                  </div>
                </div>
              </div>
              <?php $i++; } ?>
            </div>
          </div>
        </div>
      </div>
    </div>
</section>
<!-- pricing sections end -->








