<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class qrCode extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'QR Code', 'staco-core' );
		$this->rt_base = 'staco-qrcode';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__('QR Code', 'staco-core'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'image_icon',
			[
				'label' => esc_html__('Icon Image', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'drop_download_img1',
			[
				'label' => esc_html__('Drop-download Image 1', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'drop_download_img2',
			[
				'label' => esc_html__('Drop-download Image 2', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
            'global_style_area',
            [
                'label' => esc_html__( 'Global Style', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'icon_bg',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Icon Background', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .qr-code-btn .view-qr' => 'background: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'drob_bg',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Drop-down Background Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .qr-code-btn .qr-code-box' => 'background: {{VALUE}}',
				],
			]
		);
       
        $this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}