<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
?>
<div class="v1_roadmap_contents">
    <div class="roadmapSlider swiper-container">
        <div class="swiper-wrapper" data-carousel-options="<?php echo esc_attr( $data['swiper_data'] ); ?>">
			<?php if ( $data['roadmaps'] ):
				foreach ( $data['roadmaps'] as $slide ):
					$image = wp_get_attachment_image( $slide['slider_image']['id'], 'full' );
					?>
                    <div class="swiper-slide v1_roadmap_contents_text">
                        <?php if ( $slide['subtitle'] ) : ?>
                            <h5 class="subtitle">
                                <span><?php echo $slide['subtitle']; ?></span>
                                <?php echo wp_kses_post( $image ); ?>
                            </h5>
                        <?php endif; ?>
                        <?php if ( $slide['title'] ) : ?>
                            <h3><?php echo $slide['title']; ?></h3>
                        <?php endif; ?>
                        <?php if ( $slide['desc'] ) : ?>
                            <p><?php echo $slide['desc']; ?></p>
                        <?php endif; ?>
                    </div>
				<?php endforeach;
			endif; ?>
        </div>
    </div>
</div>