<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>


<section class="safe-platform-section">
    <div class="main-content" data-spy="scroll" data-target="#myScrollspy" data-offset="20">
        <div class="sidebar">
            <div class="sidebar__inner" id="myScrollspy">
                <div class="safe-platform-header">
                    <div class="container">
                        <div class="section-title crypto2 title-green">
                            <span class="sub-title"><?php echo wp_kses_post($data['subtitle']); ?></span>
                            <h2 class="title text-white"><?php echo wp_kses_post($data['top_title']); ?></h2>
                        </div>
                        <?php if(!empty($data['bg_image']['url'])){?>
                        <div class="safe-platform-img">
                            <img src="<?php echo esc_url($data['bg_image']['url']); ?>" alt="background image">
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="safe-platform-content-section">
            <div class="container">
                <div class="safe-platform-content">


                    <?php 
                        $i=0;
                        foreach ( $data['step_list'] as $item ){  
                    ?> 
                    <div class="safe-platform-text">
                        <div class="safe-platform-icon">
                            <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?>
                        </div>
                        <div class="safe-platform-right">
                            <h4><?php echo wp_kses_post($item['title']) ?></h4>
                            <p><?php echo wp_kses_post($item['desc']) ?></p>

                            <?php if(!empty($item['button1'] || $item['button2'])) { ?>
                            <div class="tags">
                                <a href="#"><?php echo wp_get_attachment_image( $item['btn_icon1']['id'], 'full' ); ?><?php echo wp_kses_post($item['button1']) ?></a>
                                <a href="#"><?php echo wp_get_attachment_image( $item['btn_icon2']['id'], 'full' ); ?><?php echo wp_kses_post($item['button2']) ?></a>
                            </div>
                            <?php } ?>

                            <?php if(!empty($item['number_title1'] || $item['number_title2'] || $item['number_test1'] || $item['number_test2'] )) { ?>     
                            <ul class="chashback-list">
                                <li>
                                    <h4><?php echo wp_kses_post($item['number_title1']) ?></h4>
                                    <span><?php echo wp_kses_post($item['number_test1']) ?></span>
                                </li>
                                <li>
                                    <h4><?php echo wp_kses_post($item['number_title2']) ?></h4>
                                    <span><?php echo wp_kses_post($item['number_test2']) ?></span>
                                </li>
                            </ul>
                            <?php } ?>


                        </div>
                    </div>
                     <?php } ?>

                </div>
            </div>
        </div>
    </div>
</section>
<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            var sidebarSticky = $(".sidebar");
            if (sidebarSticky.length) {
                var sidebar = new StickySidebar(".sidebar", {
                    topSpacing: 20,
                    bottomSpacing: 20,
                    containerSelector: ".main-content",
                    innerWrapperSelector: ".sidebar__inner",
                });
            }
        });
    })(jQuery);
</script>






