<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
// namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper;  ?>


<div class="why-choose-parent">
    <div class="overlay-left"></div>
    <div class="overlay-right"></div>
    <div class="why-choose-container container">
        <div class="container">
            <div class="why-choose-tab">
                <div class="tab-buttons why-chose-slider-nav">

                    <?php foreach ( $data['price_list'] as $items => $item ) { 
                        $serial_number  = !empty($item['serial_number']) ? $item['serial_number'] : '';                            
                        $step_title     = !empty($item['step_title']) ? $item['step_title'] : '';
                    ?>   
                    <button class="tab-btn">
                        <span><?php echo wp_kses_post ($serial_number);?></span>
                        <span class="text2"><?php echo wp_kses_post ($step_title);?></span>
                    </button>
                    <?php } ?>
                </div>
                <progress max="100" value="0"></progress>
            </div>
        </div>

        <div class="row why-chose-slider">
            <?php foreach ( $data['price_list'] as $items => $item ) {                           
                $image_icon     = !empty($item['image_icon']) ? $item['image_icon'] : '';                            
                $title          = !empty($item['title']) ? $item['title'] : '';                                                     
                $features       = !empty($item['features']) ? $item['features'] : '';                            
            ?>    
            <div class="col-md-12">
                <div class="section">
                    <div class="tab-body">
                        <div class="tab-body-img">
                            <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?>
                        </div>
                        <div class="tab-body-text">
                            <h2><?php echo wp_kses_post ($title);?></h2>
                            <?php echo wp_kses_post ($features);?>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?> 
        </div>
        
    </div>
</div>

<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {

           /*-- whyChoseSlider js start --*/
    var whyChoseSlider = $(".why-chose-slider");
    if (whyChoseSlider.length) {
        $(".why-chose-slider").slick({
            centerMode: true,
            centerPadding: "15%",
            slidesToShow: 1,
            arrows: false,
            dots: false,
            autoplay: true,
            autoplaySpeed: 3000,
            asNavFor: ".why-chose-slider-nav",
            pauseOnHover: false,
            pauseOnFocus: false,
            responsive: [
                {
                    breakpoint: 1400,
                    settings: {
                        centerPadding: "10%",
                        arrows: false,
                    },
                    breakpoint: 1200,
                    settings: {
                        centerMode: false,
                        arrows: false,
                        slidesToShow: 1,
                    },
                },
            ],
        });
    }
    /*-- whyChoseSlider js End --*/

    /*-- whyChoseSliderNav js start --*/
    var whyChoseSliderNav = $(".why-chose-slider-nav");
    if (whyChoseSliderNav.length) {
        $(".why-chose-slider-nav").slick({
            slidesToShow: 4,
            slidesToScroll: 1,
            autoplay: true,
            autoplaySpeed: 3000,
            asNavFor: ".why-chose-slider",
            dots: false,
            pauseOnHover: false,
            pauseOnFocus: false,
            centerMode: false,
            focusOnSelect: true,
        });
    }
    /*-- whyChoseSliderNav js End --*/
            
        });
    })(jQuery);
</script>




 

