<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Repeater;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class ScrollStep extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Scroll Step', 'staco-core' );
		$this->rt_base = 'scroll-step';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {
		$this->start_controls_section(
            'step_section',
            [
                'label' => esc_html__( 'Scroll Step', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'layout',
			[
				'label' => __('Layout Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Style 1', 'staco-core' ),
					'style2' => __( 'Style 2', 'staco-core' ),
				],
				'label_block' => true,
			]
		);
        $repeater = new Repeater();
        $repeater->add_control(
			'image_icon',
			[
				'label'   => __( 'Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
            'number',
            [
                'label' => esc_html__( 'Number', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        
        $repeater->add_control(
			'desc',
			[
				'label'   => esc_html__( 'Description', 'staco-core' ),
				'type'    => Controls_Manager::WYSIWYG,
			]
		);
        $repeater->add_control(
			'icon1',
			[
				'label'       => __( 'Icon One', 'SoftCoders-header-footer-elementor' ),
				'type'        => Controls_Manager::ICONS,
				'label_block' => 'true',
			]
		);
        $repeater->add_control(
			'list1',
			[
				'label'   => esc_html__( 'List Text One', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
			]
		);
        $repeater->add_control(
			'icon2',
			[
				'label'       => __( 'Icon Two', 'SoftCoders-header-footer-elementor' ),
				'type'        => Controls_Manager::ICONS,
				'label_block' => 'true',
			]
		);
        $repeater->add_control(
			'list2',
			[
				'label'   => esc_html__( 'List Text Two', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
			]
		);
        $repeater->add_control(
			'icon3',
			[
				'label'       => __( 'Icon Three', 'SoftCoders-header-footer-elementor' ),
				'type'        => Controls_Manager::ICONS,
				'label_block' => 'true',
			]
		);
        $repeater->add_control(
			'list3',
			[
				'label'   => esc_html__( 'List Text Three', 'staco-core' ),
				'type'    => Controls_Manager::TEXT,
			]
		);

        
        $this->add_control(
            'step_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        ); 
        $this->end_controls_section();

    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
        if ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		}
		$this->rt_template( $template, $data );
	}

}