<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Icons_Manager;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class servicesGrid extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Services Grid', 'staco-core' );
		$this->rt_base = 'staco-services-box';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_services',
			[
				'label' => esc_html__('Services Global', 'scaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'layout',
			[
				'label' => __('Layout Type', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => __( 'Style 1', 'staco-core' ),
					'style2' => __( 'Style 2', 'staco-core' ),
					'style3' => __( 'Style 3', 'staco-core' ),
					'style4' => __( 'Style 4', 'staco-core' ),
					'style5' => __( 'Style 5', 'staco-core' ),
					'style6' => __( 'Style 6', 'staco-core' ),
					'style7' => __( 'Style 7', 'staco-core' ),
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'reverse_effect',
			[
				'label' => __('Effect Style', 'staco-core'),
				'type' => Controls_Manager::SELECT,
				'default' => 'default_style',
				'options' => [
					'default_style' => __( 'Default', 'staco-core' ),
					'reverse_style' => __( 'Reverse', 'staco-core' ),
				],
				'label_block' => true,
				'condition'      => ['layout' => 'style4'],
			]
		);
		$this->add_control(
			'icon_display',
			[
				'label' => esc_html__( 'Active Border', 'staco-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'staco-core' ),
				'label_off' => esc_html__( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__('Alignment', 'scaddon'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'scaddon'),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'scaddon'),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'scaddon'),
						'icon' => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__('Justify', 'scaddon'),
						'icon' => 'fa fa-align-justify',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .feature-card' => 'text-align: {{VALUE}}'
				],
				'separator' => 'before',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_icon',
			[
				'label' => esc_html__('Image', 'scaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'sevice_image_icon',
			[
				'label' => esc_html__('Icon Image', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
				'condition'      => ['layout' => '!style6'],
			]
		);
		$this->add_control(
			'sevice_image',
			[
				'label' => esc_html__('Background Image', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__('Title & Description', 'scaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => esc_html__('Services Title', 'scaddon'),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Services Title',
				'placeholder' => esc_html__('Services Title', 'scaddon'),
				'separator'   => 'before',
			]
		);

		$this->add_control(
			'title_link',
			[
				'label_block' => true,
				'label' => esc_html__('Title Link', 'scaddon'),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__('#', 'scaddon'),
			]
		);

		$this->add_control(
			'link_open',
			[
				'label'   => esc_html__('Link Open New Window', 'scaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'no' => esc_html__('No', 'scaddon'),
					'yes' => esc_html__('Yes', 'scaddon'),

				],
			]
		);
		$this->add_control(
			'text',
			[
				'label' => esc_html__('Services Text', 'scaddon'),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'separator' => 'before',
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'section_button',
			[
				'label' => esc_html__('Button', 'scaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'services_btn_text',
			[
				'label' => esc_html__('Services Button Text', 'scaddon'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'Load More',
				'placeholder' => esc_html__('Services Button Text', 'scaddon'),
				'separator' => 'before',
			]
		);

		$this->add_control(
			'services_btn_link',
			[
				'label' => esc_html__('Services Button Link', 'scaddon'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '',
				'placeholder' => esc_html__('#', 'scaddon'),
			]
		);

		$this->add_control(
			'btn_image_icon',
			[
				'label' => esc_html__('Icon Image', 'scaddon'),
				'type' => Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'services_btn_link_open',
			[
				'label'   => esc_html__('Link Open New Window', 'scaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'no' => esc_html__('No', 'scaddon'),
					'yes' => esc_html__('Yes', 'scaddon'),

				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'_section_area_style',
			[
				'label' => esc_html__('Global Style', 'scaddon'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'item_padding_area',
			[
				'label' => esc_html__('Padding', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .how-works-card, {{WRAPPER}} .index6-card.index8-card, {{WRAPPER}} .feature-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'item_bg_color',
				'label' => esc_html__('Background Color', 'scaddon'),
				'types' => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .how-works-card, {{WRAPPER}} .feature-card'
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'item_box_shadow',
				'selector' => '{{WRAPPER}} .how-works-card, {{WRAPPER}} .feature-card'
			]
		);

		$this->end_controls_section();

		// Icon Style
		$this->start_controls_section(
			'_section_media_style',
			[
				'label' => esc_html__('Icon', 'scaddon'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__('Size', 'scaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .feature-card-icon i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
					'{{WRAPPER}} .feature-card-icon svg' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'image_width',
			[
				'label' => esc_html__('Width', 'scaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 400,
					],
					'%' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .feature-card-icon' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .feature-card-icon' => 'width: {{SIZE}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'image_min_width',
			[
				'label' => esc_html__('Min Width', 'scaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 400,
					],
					'%' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .feature-card-icon' => 'min-width: {{SIZE}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'image_height',
			[
				'label'      => esc_html__('Height', 'scaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 400,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .feature-card-icon' => 'min-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .feature-card-icon' => 'height: {{SIZE}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);


		$this->add_responsive_control(
			'media_margin',
			[
				'label' => esc_html__('Margin', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .feature-card-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'media_padding',
			[
				'label' => esc_html__('Padding', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .feature-card-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'media_border',
				'selector' => '{{WRAPPER}} .feature-card-icon',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'media_box_shadow',
				'selector' => '{{WRAPPER}} .feature-card-icon'
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__('Color', 'scaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .feature-card-icon i' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .feature-card-icon svg path' => 'fill: {{VALUE}} !important',
				],
			]
		);

		$this->add_control(
			'icon_hover_color',
			[
				'label' => esc_html__('Hover Color', 'scaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .feature-card:hover .feature-card-icon i' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .feature-card:hover .feature-card-icon svg path' => 'fill: {{VALUE}} !important',
				],
			]
		);

		$this->add_control(
			'icon_bg_color',
			[
				'label' => esc_html__('Background Color', 'scaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .app-benefits-card-img.account, {{WRAPPER}} .feature-card .feature-card-icon' => 'background-color: {{VALUE}} !important',
				],
			]
		);


		$this->add_control(
			'icon_hover_bg_color',
			[
				'label' => esc_html__('Hover Background Color', 'scaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .feature-card:hover .feature-card-icon' => 'background-color: {{VALUE}} !important',
				],
			]
		);

		$this->add_responsive_control(
			'media_border_radius',
			[
				'label' => esc_html__('Border Radius', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .app-benefits-card-img.account,  {{WRAPPER}} .feature-card .feature-card-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'_section_title_style',
			[
				'label' => esc_html__('Title & Description', 'scaddon'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__('Content Box Padding', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .app-benefits-card-text, {{WRAPPER}} .feature-card p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'margin_padding',
			[
				'label' => esc_html__('Content Box Margin', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .app-benefits-card-text, {{WRAPPER}} .feature-card p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'content_box_shadow',
				'exclude' => [
					'box_shadow_position',
				],
				'selector' => '{{WRAPPER}} .app-benefits-card-text, {{WRAPPER}} .feature-card p'
			]
		);

		$this->add_control(
			'title_heading',
			[
				'type' => Controls_Manager::HEADING,
				'label' => esc_html__('Title', 'scaddon'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'title_spacing',
			[
				'label' => esc_html__('Bottom Spacing', 'scaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [

					'{{WRAPPER}} .how-works-card h4, {{WRAPPER}} .app-benefits-card-text h5, {{WRAPPER}} .index6-card h5, {{WRAPPER}} .feature-card h2' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'scaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .how-works-card h4, {{WRAPPER}} .app-benefits-card-text h5, {{WRAPPER}} .index6-card h5, {{WRAPPER}} .feature-card h2' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'description_heading',
			[
				'type' => Controls_Manager::HEADING,
				'label' => esc_html__('Description', 'scaddon'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'description_spacing',
			[
				'label' => esc_html__('Bottom Spacing', 'scaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .how-works-card p, {{WRAPPER}} .app-benefits-card-text p, {{WRAPPER}} .index6-card p, {{WRAPPER}} .feature-card p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'description_color',
			[
				'label' => esc_html__('Color', 'scaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .how-works-card p, {{WRAPPER}} .app-benefits-card-text p, {{WRAPPER}} .index6-card p, {{WRAPPER}} .feature-card p' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'description_hover_color',
			[
				'label' => esc_html__('Hover Color', 'scaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .feature-card p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'bnt_section',
			[
				'label' => esc_html__('Button Style', 'scaddon'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'btn_color',
			[
				'label' => esc_html__('Color', 'scaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .index6-card a span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn_color_hover',
			[
				'label' => esc_html__('Hover Color', 'scaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .index6-card a:hover span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();

    }
	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		if ( 'style2' == $data['layout'] ) {
			$template = 'view-2';
		}
		if ( 'style3' == $data['layout'] ) {
			$template = 'view-3';
		}
		if ( 'style4' == $data['layout'] ) {
			$template = 'view-4';
		}
		if ( 'style5' == $data['layout'] ) {
			$template = 'view-5';
		}
		if ( 'style6' == $data['layout'] ) {
			$template = 'view-6';
		}
		if ( 'style7' == $data['layout'] ) {
			$template = 'view-7';
		}
		$this->rt_template( $template, $data );
	}

}
