<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>

<?php if ( 'default_style' == $data['reverse_effect'] ) { ?>
<div class="safe-platform-ball safe-platform-ball1">
    <?php if (!empty($data['sevice_image_icon']['url'])) : ?>
    <span><img src="<?php echo esc_url($data['sevice_image_icon']['url']); ?>" alt="icon"></span>
    <?php endif; ?>
    <h4><?php echo wp_kses_post($data['title']); ?></h4>
    <p><?php echo wp_kses_post($data['text']); ?></p>
</div>

<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            var upBall = $(".safe-platform-ball1");
            if (upBall.length) {
                $(window).on("scroll", function () {
                    var cryptoBannerImg = $(".safe-platform-ball1");
                    var y = window.scrollY;
                    var x;
                    x = cryptoBannerImg.offset().top;
                    x = x - 400;

                    let animationValue = 1;
                    animationValue = (-1* (y - x)) / 8;          

                    let animationStop = 100;

                    if (animationValue < 0) {
                        animationValue > 0;
                    }

                    if (animationValue > animationStop) {
                        animationValue = animationStop;
                    }

                    cryptoBannerImg.css("transform", `translateY(${animationValue}px)`);
                });
            }
        });
    })(jQuery);
</script>
<?php } ?>

<?php if ( 'reverse_style' == $data['reverse_effect'] ) { ?>
<div class="safe-platform-ball safe-platform-ball2">
    <?php if (!empty($data['sevice_image_icon']['url'])) : ?>
    <span><img src="<?php echo esc_url($data['sevice_image_icon']['url']); ?>" alt="icon"></span>
     <?php endif; ?>
    <h4><?php echo wp_kses_post($data['title']); ?></h4>
    <p><?php echo wp_kses_post($data['text']); ?></p>
</div>

<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            var downBall = $(".safe-platform-ball2");
    if (downBall.length) {
        $(window).on("scroll", function () {
            var cryptoBannerImg = $(".safe-platform-ball2");
            var y = window.scrollY;
            var x;
            x = cryptoBannerImg.offset().top;
            x = x - 400;

            let animationValue = 1;
            animationValue = (y - x) / 8;  

            let animationStop = 100;

            if (animationValue < 0) {
                animationValue > 0;
            }

            if (animationValue > animationStop) {
                animationValue = animationStop;
            }

            cryptoBannerImg.css("transform", `translateY(${animationValue}px)`);
        });
    }
        });
    })(jQuery);
</script>
<?php } ?>




