<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>



<div class="defi-safe-platform-content">
    <?php if (!empty($data['sevice_image_icon']['url'])) : ?>
    <div class="defi-safe-platform-img">
        <img src="<?php echo esc_url($data['sevice_image_icon']['url']); ?>" alt="icon">
    </div>
    <?php endif; ?>
    <div class="defi-safe-platform-text">
        <h4><?php echo wp_kses_post($data['title']); ?></h4>
        <p><?php echo wp_kses_post($data['text']); ?></p>
    </div>
</div>

<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {

            var defiSafePlatformImg = $(".defi-safe-platform-img img");
            if (defiSafePlatformImg.length) {
                $(window).on("scroll", function () {
                    var defiSafePlatformImg = $(".defi-safe-platform-img img");
                    var y = window.scrollY;
                    var x;
                    x = defiSafePlatformImg.offset().top;
                    x = x - 400;

                    let animationValue = 1;
                    animationValue = (y - x) / 4;          

                    let animationStop = 100;

                    if (animationValue < 0) {
                        animationValue = 0;
                    }

                    if (animationValue > animationStop) {
                        animationValue = animationStop;
                    }

                    defiSafePlatformImg.css("transform", `translateY(${animationValue}px)`);
                });
            }

        });
    })(jQuery);
</script>
