<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\Staco_Core;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class servicesList extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Services List', 'staco-core' );
		$this->rt_base = 'services-list';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {
		$this->start_controls_section(
            '_section_price',
            [
                'label' => esc_html__( 'Services List', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new Repeater();
        

        $repeater->add_control(
			'image_icon',
			[
				'label'   => __( 'Slider Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
			'title', [
				'label' => __( 'Title', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

        $repeater->add_control(
			'description', [
				'label' => __( 'Description', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'link', [
				'label' => __( 'Link', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

        $this->add_control(
            'price_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        ); 


        $this->end_controls_section();

        $this->start_controls_section(
            'global_style_area',
            [
                'label' => esc_html__( 'Global Style', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Title Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .download-wallet-list ul li a h6' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'desc_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Description Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .download-wallet-list ul li a p' => 'background: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'bg_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Background Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .download-wallet-list ul li a' => 'background: {{VALUE}}',
				],
			]
		);
        $this->add_responsive_control(
            'sec_padding',
            [
                'label' => esc_html__( 'Padding', 'rsaddon' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .download-wallet-list ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
       
        $this->end_controls_section();
        
    }

    protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}