<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\Staco_Core;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class servicesSlider extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Services Slider', 'staco-core' );
		$this->rt_base = 'services-slider';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {
		$this->start_controls_section(
            '_section_price',
            [
                'label' => esc_html__( 'Services Slider', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new Repeater();
        

        $repeater->add_control(
			'image_icon',
			[
				'label'   => __( 'Slider Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
			'title', [
				'label' => __( 'Title', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

        $repeater->add_control(
			'description', [
				'label' => __( 'Description', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);

        $this->add_control(
            'price_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        ); 
    
        $this->add_control(
            'col_lg',
            [
                'label'   => esc_html__( 'Desktops > 1199px', 'rtelements' ),
                'type'    => Controls_Manager::SELECT,  
                'default' => 3,
                'options' => [
                    '1' => esc_html__( '1 Column', 'rtelements' ), 
                    '2' => esc_html__( '2 Column', 'rtelements' ),
                    '3' => esc_html__( '3 Column', 'rtelements' ),
                    '4' => esc_html__( '4 Column', 'rtelements' ),
                    '6' => esc_html__( '6 Column', 'rtelements' ),                 
                ],
                'separator' => 'before',
                            
            ]
            
        );

        $this->add_control(
            'col_md',
            [
                'label'   => esc_html__( 'Desktops > 991px', 'rtelements' ),
                'type'    => Controls_Manager::SELECT,  
                'default' => 3,         
                'options' => [
                    '1' => esc_html__( '1 Column', 'rtelements' ), 
                    '2' => esc_html__( '2 Column', 'rtelements' ),
                    '3' => esc_html__( '3 Column', 'rtelements' ),
                    '4' => esc_html__( '4 Column', 'rtelements' ),
                    '6' => esc_html__( '6 Column', 'rtelements' ),                     
                ],
                'separator' => 'before',
                            
            ]
            
        );

        $this->add_control(
            'col_sm',
            [
                'label'   => esc_html__( 'Tablets > 767px', 'rtelements' ),
                'type'    => Controls_Manager::SELECT,  
                'default' => 2,         
                'options' => [
                    '1' => esc_html__( '1 Column', 'rtelements' ), 
                    '2' => esc_html__( '2 Column', 'rtelements' ),
                    '3' => esc_html__( '3 Column', 'rtelements' ),
                    '4' => esc_html__( '4 Column', 'rtelements' ),
                    '6' => esc_html__( '6 Column', 'rtelements' ),                 
                ],
                'separator' => 'before',
                            
            ]
            
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'global_style_area',
            [
                'label' => esc_html__( 'Global Style', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Title Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .best-services-text h5' => 'background: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'desc_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Description Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .best-services-text p' => 'background: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'bg_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .best-services-card' => 'background: {{VALUE}}',
				],
			]
		);
        $this->add_responsive_control(
            'sec_padding',
            [
                'label' => esc_html__( 'Padding', 'rsaddon' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .best-services-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
			'pagination_border_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Navigation Border Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .best-services-section .slick-next' => 'border-color: {{VALUE}}',
				],
			]
		);
        $this->add_responsive_control(
		    'shape_left-position',
		    [
		        'label' => esc_html__( 'Navigation Left Postion', 'rsaddon' ),
		        'type' => Controls_Manager::TEXT,
		        'size_units' => [ 'px' ],
		        'selectors' => [
		            '{{WRAPPER}} .best-services-section .slick-prev' => 'left: {{SIZE}}px;',
		        ],
		        'separator' => 'before',
		    ]
		);
        $this->add_responsive_control(
		    'shape_right-position',
		    [
		        'label' => esc_html__( 'Navigation Right Postion', 'rsaddon' ),
		        'type' => Controls_Manager::TEXT,
		        'size_units' => [ 'px' ],
		        'selectors' => [
		            '{{WRAPPER}} .best-services-section .slick-next' => 'left: {{SIZE}}px;',
		        ],
		        'separator' => 'before',
		    ]
		);
       
        $this->end_controls_section();
        
    }

    protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}