<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
// namespace UiGigs\Staco_Core;
use UiGigs\staco\Helper;  ?>
<div class="best-services-section">
    <div class="corporate-servicels-slider">
            <?php foreach ( $data['price_list'] as $items => $item ) {                           
                $image_icon     = !empty($item['image_icon']) ? $item['image_icon'] : '';   
                $title          = !empty($item['title']) ? $item['title'] : '';  
                $description          = !empty($item['description']) ? $item['description'] : '';                         
            ?>
            <div class="sc-service-slider">
                <div class="best-services-card">
                    <div class="best-services-img">
                        <?php echo wp_get_attachment_image( $item['image_icon']['id'], 'full' ); ?>
                    </div>
                    <div class="best-services-text">
                        <h5 class="wt-700"><?php echo wp_kses_post ($title);?></h5>
                        <p><?php echo wp_kses_post ($description);?></p>
                    </div>
                </div>
            </div>
        <?php } ?> 
    </div>
</div>


<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
        var corporateServicelsSlider = $(".corporate-servicels-slider");
        if (corporateServicelsSlider.length) {
            $(".corporate-servicels-slider").slick({
                slidesToShow: <?php echo wp_kses_post( $data['col_lg'] ); ?>,
                slidesToScroll: 1,
                arrows: true,
                infinite: true,
                pauseOnHover: false,
                pauseOnFocus: false,
                dots: false,
                responsive: [
                    {
                        breakpoint: 991,
                        settings: {
                            arrows: false,
                            dots: true,
                            autoplay: true,
                            autoplaySpeed: 3000,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: <?php echo wp_kses_post( $data['col_md'] ); ?>,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: <?php echo wp_kses_post( $data['col_sm'] ); ?>,
                            slidesToScroll: 1
                        }
                    }
                ]
            });
        }

    });
    })(jQuery);
</script>



 

