<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager; ?>
<a href="<?php echo wp_kses_post($data['link']); ?>">
    <div class="defi-get-update-card btn-hov-effect">
        <h5 class="dm-sans"><?php if($data['image_icon']['url']){ ?><span><img src="<?php echo esc_url($data['image_icon']['url']); ?>" alt="icon"></span><?php } ?><?php echo wp_kses_post($data['title']); ?></h5>
        <p><?php echo wp_kses_post($data['desc']); ?></p>
        <span class="round-shape"></span>
    </div>
</a>
<script>
    (function ($) {
    ("use strict");
        $(document).ready(function () {
            var btnEffect = $(".btn-hov-effect");
            if (btnEffect.length) {
                let button = document.querySelectorAll(".btn-hov-effect");
                button.forEach((item) => {
                    let roundItem = item.querySelector(".round-shape");

                    item.addEventListener("mouseenter", () => {
                        item.classList.add("animate");

                        let buttonX = event.offsetX;
                        let buttonY = event.offsetY;

                        if (buttonY < 105) {
                            roundItem.style.top = 0 + "px";
                        } else if (buttonY > 30) {
                            roundItem.style.top = 210 + "px";
                        }

                        roundItem.style.left = buttonX + "px";
                        roundItem.style.width = "1px";
                        roundItem.style.height = "1px";
                    });
                    item.addEventListener("mouseleave", () => {
                        item.classList.remove("animate");

                        let buttonX = event.offsetX;
                        let buttonY = event.offsetY;

                        if (buttonY < 105) {
                            roundItem.style.top = 0 + "px";
                        } else if (buttonY > 30) {
                            roundItem.style.top = 210 + "px";
                        }
                        roundItem.style.left = buttonX + "px";
                    });
                });
            }
        })
    })(jQuery);
</script>



