<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class SocialMedia extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Social Media', 'staco-core' );
		$this->rt_base = 'staco-social-media';
		parent::__construct( $data, $args );
	}

	protected function register_controls() {

		/* = SocialMedia Options
		============================================*/
		$this->start_controls_section(
			'social_media_list',
			[
				'label' => __( 'Social Media List', 'staco-core' ),
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'icon', [
				'label'            => esc_html__( 'Choose Icon', 'staco-core' ),
				'type'             => Controls_Manager::ICONS,
				'default'          => [
					'value'   => 'fas fa-home',
					'library' => 'fa-solid',
				]
			]
		);
		$repeater->add_control(
			'link', [
				'type'        => Controls_Manager::URL,
				'label' 	  => esc_html__( 'Link', 'evacon-core' ),
				'placeholder' => 'https://your-link.com',
			]
		);

		$this->add_control(
			'social_list',
			[
				'label'       => esc_html__( 'Social Icons', 'staco-core' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'link' => 'https://your-link.com',
					],
					[
						'link' => 'https://your-link.com',
					],
				],
			]
		);
		$this->end_controls_section();

		/* = Icon Settings
		==============================================================*/
		$this->start_controls_section(
			'icon_settings',
			[
				'label' => esc_html__( 'Icon Settings', 'staco-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'icon_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .social_media_buttons li a i' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
    }

	protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}