<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

use Elementor\Icons_Manager;

?>
<ul class="social_media_buttons social-addon">
    <?php foreach ( $data['social_list'] as $value ):
        $attr = '';
        if ( !empty( $value['link']['url'] ) ) {
            $attr  = 'href="' . $value['link']['url'] . '"';
            $attr .= !empty( $value['link']['is_external'] ) ? ' target="_blank"' : '';
            $attr .= !empty( $value['link']['nofollow'] ) ? ' rel="nofollow"' : '';
        }
    ?>
    <li>
      <a <?php echo wp_kses_post( $attr ); ?>>
          <?php Icons_Manager::render_icon( $value['icon'], [ 'aria-hidden' => 'true' ] ); ?>
      </a>
    </li>
    <?php endforeach; ?>
</ul>