<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\Staco_Core;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class stacoSlider extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Staco Slider', 'staco-core' );
		$this->rt_base = 'staco-slider';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {
		$this->start_controls_section(
            '_section_price',
            [
                'label' => esc_html__( 'Scroll Slider', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control(
			'title', [
				'label' => __( 'Title', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

        $repeater->add_control(
			'image_icon',
			[
				'label'   => __( 'Slider Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
            'price_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        ); 

        $this->end_controls_section();

        $this->start_controls_section(
            'global_style_area',
            [
                'label' => esc_html__( 'Global Style', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'bg_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .crypto-hero-img .mobile-img' => 'background: {{VALUE}}',
				],
			]
		);
        $this->add_responsive_control(
            'sec_padding',
            [
                'label' => esc_html__( 'Padding', 'rsaddon' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .crypto-hero-img .mobile-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        
    }

    protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}