<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;
use Elementor\Icons_Manager;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit;

class stacoVideo extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Staco Video', 'staco-core' );
		$this->rt_base = 'staco-video';
		parent::__construct( $data, $args );
	}


	protected function register_controls() {

		$this->start_controls_section(
			'section_video',
			[
				'label' => esc_html__('Content', 'staco'),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__('Title Alignment', 'staco'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'staco'),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'staco'),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'staco'),
						'icon' => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__('Justify', 'staco'),
						'icon' => 'fa fa-align-justify',
					],
				],
				'default'     => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .staco-video' => 'text-align: {{VALUE}}'
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'staco_video_style',
			[
				'label'   => esc_html__('Select Video Style', 'staco'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'defualt' => esc_html__('Defualt', 'staco'),
					'style1' => esc_html__('Style 1', 'staco'),
					'style2' => esc_html__('Style 2', 'staco'),
					'style3' => esc_html__('Style 3', 'staco'),
				],
			]
		);

		

		$this->add_control(
			'video_link',
			[
				'label' => esc_html__('Enter Link Here', 'staco'),
				'type' => Controls_Manager::TEXT,
				'default'     => '#',
				'placeholder' => esc_html__('Video link here', 'staco'),
				'separator' => 'before',
			]
		);

		$this->add_control(
			'selected_icon',
			[
				'label' => __('Icon', 'elementor'),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-photo-video',
					'library' => 'fa-solid',
				],
				'condition' => [
					'staco_video_style' => 'defualt'
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label' => esc_html__('Choose Background Image', 'staco'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sc_video_title',
			[
				'label' => esc_html__('Video Title', 'staco'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'separator' => 'before',
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->add_control(
			'description',
			[
				'label' => esc_html__('Video Description', 'staco'),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default'     => 'Add your video description here',
				'placeholder' => esc_html__('Add your video content here..', 'staco'),
				'separator' => 'before',
				'condition' => [
					'staco_video_style!' => 'defualt'
				],
			]

		);
		$this->add_control(
			'sc_video_subtitle',
			[
				'label' => esc_html__('Video Subtitle', 'staco'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'separator' => 'before',
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->add_control(
			'sc_video_btn',
			[
				'label' => esc_html__('Button Text', 'staco'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'separator' => 'before',
				'default'     => 'Button Text',
				'placeholder' => esc_html__('Add button text here..', 'staco'),
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->add_control(
			'sc_video_btn_link',
			[
				'label' => esc_html__('Button Link Text', 'staco'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'separator' => 'before',
				'default'     => '#',
				'placeholder' => esc_html__('Add button link here..', 'staco'),
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__('Content', 'staco'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'staco_video_style!' => 'defualt'
				],
			]
		);
		$this->add_control(
			'title_color_style2',
			[
				'label' => esc_html__('Title Color', 'staco'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video_title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'video_title_text',
				'selector' => '{{WRAPPER}} .video_title',

			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Content Text Color', 'staco'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-desc' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography_text',
				'selector' => '{{WRAPPER}} .video-desc',

			]
		);
		$this->add_responsive_control(
			'video_title_postion',
			[
				'label' => esc_html__('Content Position Vertical', 'staco'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .staco-video .video-desc' => 'top: {{SIZE}}px;',
				],
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label' => esc_html__('Subtitle Color', 'staco'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .staco-video .video-desc span' => 'color: {{VALUE}};',
				],
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Subtitle Typography', 'staco'),
				'name' => 'sub_title_text',
				'selector' => '{{WRAPPER}} .staco-video .video-desc span',
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->add_responsive_control(
			'video_full_area_padding',
			[
				'label' => esc_html__('Area Padding', 'staco'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .staco-video' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'border_radius',
			[
				'label' => esc_html__('Video Border Radius', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .v6-banner-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'staco_video_style' => 'style3'
				],
			]
		);

		$this->add_responsive_control(
			'video_height',
			[
				'label' => esc_html__('Video Height', 'scaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 400,
					],
					'%' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .v6-banner-img-section, {{WRAPPER}} .v6-banner-img' => 'height: {{SIZE}}{{UNIT}};',
				],
				'separator' => 'before',
				'condition' => [
					'staco_video_style' => ['style3', 'style1', 'defualt']
				],
			]
		);

		$this->add_responsive_control(
			'video_width',
			[
				'label' => esc_html__('Width', 'scaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 400,
					],
					'%' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .v6-banner-img-section, {{WRAPPER}} .v6-banner-img' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .v6-banner-img-section, {{WRAPPER}} .v6-banner-img' => 'max-width: {{SIZE}}{{UNIT}};',
				],
				'separator' => 'before',
				'condition' => [
					'staco_video_style' => ['style3', 'style1', 'defualt']
				],
			]
		);
		
		$this->add_control(
			'icont_border_radius',
			[
				'label' => esc_html__('Icon Border Radius', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .staco-video-part .video-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'shape_bg',
			[
				'label' => esc_html__('Shape Background', 'staco'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .v6-banner-img::after' => 'background: {{VALUE}};',
				],
				'separator' => 'before',
				'condition' => [
					'staco_video_style' => 'style3'
				],
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_icon',
			[
				'label' => esc_html__('Icon', 'staco'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__('Icon Color', 'staco'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-icon .popup-video i, {{WRAPPER}} .staco-video .popup-videos i:before' => 'color: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'staco'),
				'name' => 'typography_icon',
				'selector' => '{{WRAPPER}} .staco-video .popup-videos i',
				'separator' => 'before',
			]
		);
		$this->add_control(
			'icon_bg',
			[
				'label' => esc_html__('Icon Background Color', 'staco'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .staco-video-part .video-icon' => 'background: {{VALUE}};',
					'{{WRAPPER}} .staco-video .popup-videos' => 'background: {{VALUE}};',
					'{{WRAPPER}} .staco-video .popup-videos:before' => 'background: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_control(
			'icon_border',
			[
				'label' => esc_html__('Icon Border Color', 'staco'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .staco-video .overly-border' => 'border-color: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'video_icon_postion_ver',
			[
				'label' => esc_html__('Icon Position Vertical', 'staco'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['%'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .staco-video.style2 .staco-icon-inner .icon-area, {{WRAPPER}} .staco-video .overly-border' => 'top: {{SIZE}}%;',
				],
			]
		);
		$this->add_responsive_control(
			'video_icon_postion_ht',
			[
				'label' => esc_html__('Icon Position Horizontal', 'staco'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['%'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],

				'selectors' => [
					'{{WRAPPER}} .staco-video.style2 .staco-icon-inner .icon-area, {{WRAPPER}} .staco-video .overly-border' => 'left: {{SIZE}}%;',
				],
			]
		);
		$this->add_control(
			'icon_display',
			[
				'label' => esc_html__( 'Icon Show/Hide', 'staco-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'staco-core' ),
				'label_off' => esc_html__( 'Hide', 'staco-core' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'staco_video_style' => 'style3'
				],
			]
		);
		$this->add_control(
			'icons_border_radius',
			[
				'label' => esc_html__('Icon Border Radius', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .staco-video-part .video-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'video_icon_height',
			[
				'label' => esc_html__('Video Height', 'scaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 400,
					],
					'%' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					' {{WRAPPER}} .staco-video-part .video-icon' => 'height: {{SIZE}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'video_icon_width',
			[
				'label' => esc_html__('Width', 'scaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 400,
					],
					'%' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .staco-video-part .video-icon' => 'min-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_boxshadow',
                'exclude' => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .staco-video-part .video-icon',
            ]
        );
		
		$this->end_controls_section();
		$this->start_controls_section(
			'section_btn',
			[
				'label' => esc_html__('Button Style', 'staco'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->add_control(
			'icon_btn',
			[
				'label' => esc_html__('Button Color', 'staco'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .staco-video.style2 .staco-icon-inner .staco-icon-btn a' => 'color: {{VALUE}};',
				],
				'separator' => 'before',
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'label' => esc_html__('Border Color', 'staco'),
				'name' => 'btn_border',
				'selector' => '{{WRAPPER}} .staco-video.style2 .staco-icon-inner .staco-icon-btn a',
			]
		);
		$this->add_control(
			'icont_border_radius2',
			[
				'label' => esc_html__('Icon Border Radius', 'scaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .staco-video-part .video-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'button_border_radius',
			[
				'label' => esc_html__('Border Radius', 'staco'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .staco-video.style2 .staco-icon-inner .staco-icon-btn a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->add_control(
			'icon_btn_hover',
			[
				'label' => esc_html__('Button Hover Color', 'staco'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .staco-video.style2 .staco-icon-inner .staco-icon-btn a:hover' => 'color: {{VALUE}};',
				],
				'separator' => 'before',
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'staco'),
				'name' => 'typography_btn',
				'selector' => '{{WRAPPER}} .staco-video.style2 .staco-icon-inner .staco-icon-btn a',
				'separator' => 'before',
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->add_control(
			'btn_bg',
			[
				'label' => esc_html__('Button Background Color', 'staco'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .staco-video.style2 .staco-icon-inner .staco-icon-btn a' => 'background: {{VALUE}};',
				],
				'separator' => 'before',
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->add_control(
			'btn_bg_hover',
			[
				'label' => esc_html__('Button Hover Background Color', 'staco'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .staco-video.style2 .staco-icon-inner .staco-icon-btn a:hover' => 'background: {{VALUE}};',
					'{{WRAPPER}} .staco-video.style2 .staco-icon-inner .staco-icon-btn a:before' => 'background: {{VALUE}};',
				],
				'separator' => 'before',
				'condition' => [
					'staco_video_style' => 'style2'
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render() {
		$data = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}
}