<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core; ?>

<?php if ($data['staco_video_style'] == 'defualt') { ?>
	<div class="staco-video-part">
		<?php if (!empty($data['image']['url'])) : ?>
			<img src="<?php echo esc_url($data['image']['url']); ?>" alt="image" />
		<?php endif; ?>
		<div class="video-icon">
			<a class="popup-video my-video-links" href="<?php echo esc_url($data['video_link']); ?>" title="Video Icon">
				<?php if (!empty($data['selected_icon'])) { ?>
						<?php \Elementor\Icons_Manager::render_icon( $data['selected_icon'], [ 'aria-hidden' => 'true' ] ); ?>
					
				<?php } ?>
			</a>
		</div>
	</div>
<?php } ?>

<?php if ($data['staco_video_style'] == 'style2' || $data['staco_video_style'] == 'style1') { ?>
	<div class="staco-video video-item-<?php echo esc_attr($rand); ?> <?php echo esc_html($data['align']); ?> <?php echo esc_html($data['staco_video_style']); ?>" <?php if (!empty($data['image']['url'])) : ?>style="background: url(<?php echo esc_url($data['image']['url']); ?>);" <?php endif; ?>>
		<?php if ($data['staco_video_style'] == 'style1') { ?>
			<div class="overly-border">
				<a class="popup-videos" href="<?php echo esc_url($data['video_link']); ?>">
					<i class="fas fa-play"></i>
				</a>
			</div>
			<?php if (!empty($data['description']) || !empty($data['sc_video_subtitle'])) : ?>
				<div <?php echo wp_kses_post($this->print_render_attribute_string('description')); ?>>
					<?php echo wp_kses_post($data['description']); ?>
				</div>
			<?php endif; ?>
		<?php }; ?>

		<?php if ($data['staco_video_style'] == 'style2') : ?>
			<span class="video_title"><?php echo esc_html($data['sc_video_title']); ?></span>
			<?php if (!empty($data['description']) || !empty($data['sc_video_subtitle'])) : ?>
				<div class="video-desc">
					<?php echo wp_kses_post($data['description']); ?>
					<?php if (!empty($data['sc_video_subtitle'])) : ?>
						<span><?php echo wp_kses_post($data['sc_video_subtitle']); ?></span>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="staco-icon-inner">
				<?php if (!empty($data['sc_video_btn'])) : ?>
					<div class="staco-icon-btn">
						<a href="<?php echo esc_url($data['sc_video_btn_link']); ?>"><?php echo esc_html($data['sc_video_btn']); ?></a>
					</div>
				<?php endif; ?>

				<div class="icon-area">
					<div class="overly-border">
						<a class="popup-videos" href="<?php echo esc_url($data['video_link']); ?>">
							<i class="fas fa-play"></i>
						</a>
					</div>
				</div>
			</div>
		<?php endif; ?>
	</div>
<?php } ?>

<?php if ($data['staco_video_style'] == 'style3') { ?>
	<div class="v6-banner-img-section">
		<div class="v6-banner-img">
			<video id="staco-h6-video" loop autoplay muted>
				<source src="<?php echo esc_url($data['video_link']); ?>" type="video/mp4" />
			</video>
			<?php if(!empty($data['icon_display'])) {?>
			<button id="staco-h6-video-control">
				<span class="play"
					><span class="iconify" data-icon="material-symbols:play-arrow"></span
				></span>
				<span class="pause"><span class="iconify" data-icon="fe:pause"></span></span>
			</button>
			<?php } ?>
		</div>
	</div>
<?php } ?>



