<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use UiGigs\staco\Helper;

if( ! class_exists('UiGigs\staco\Helper') )
	return;
?>
<div class="staco_team_card <?php echo esc_attr( $data['layout'] ) ?>">
    <div class="team_member_img">
		<?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $data, 'thumbnail', 'image' ); ?>
    </div>
    <h3>
        <?php echo esc_html( $data['name'] ); ?>
        <img src="<?php echo Helper::get_img('ab-icon-image.png'); ?>" alt="">
    </h3>
    <span class="designation"><?php echo esc_html( $data['designation'] ) ?></span>
	<?php
	if ( ! empty( $data['social_icon_list'] ) ) {
		Helper::get_user_social_info( $data['social_icon_list'] );
	}
	?>
</div>