<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\Staco_Core;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class tokenScrollSlider extends Custom_Widget_Base {
	public function __construct( $data = [], $args = null ) {
		$this->rt_name = esc_html__( 'Token Scroll Slider', 'staco-core' );
		$this->rt_base = 'token-scroll-slider';
		parent::__construct( $data, $args );
	}
	protected function register_controls() {
		$this->start_controls_section(
            '_section_price',
            [
                'label' => esc_html__( 'Token Scroll Slider', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new Repeater();
        
        $repeater->add_control(
			'image_icon',
			[
				'label'   => __( 'Animation Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
			'subtitle', [
				'label' => __( 'Sub Title', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

        $repeater->add_control(
			'title', [
				'label' => __( 'Title', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'desc',
			[
				'label'   => esc_html__( 'Description', 'staco-core' ),
				'type'    => Controls_Manager::WYSIWYG,
			]
		);

        $repeater->add_control(
			'before_number', [
				'label' => __( 'Before Number', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'counter_number', [
				'label' => __( 'Number', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'after_number', [
				'label' => __( 'After Number', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

        $repeater->add_control(
			'counter_number_text', [
				'label' => __( 'Number Text', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'before_number2', [
				'label' => __( 'Before Number 2', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

        $repeater->add_control(
			'counter_number2', [
				'label' => __( 'Number 2', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'after_number2', [
				'label' => __( 'After Number 2', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		
        $repeater->add_control(
			'counter_number_text2', [
				'label' => __( 'Number Text 2', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

        $repeater->add_control(
			'button', [
				'label' => __( 'Button Text', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'btn_icon',
			[
				'label'   => __( 'Button Icon', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
			'button_link', [
				'label' => __( 'Button Link', 'staco-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'bg_image',
			[
				'label'   => __( 'Backgrund Image', 'staco-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'background_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Background', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .crypto-token-features-cards .subtitle' => 'color: {{VALUE}}',
				],
			]
		);


        $this->add_control(
            'price_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        ); 

        $this->end_controls_section();

        $this->start_controls_section(
            'global_style_area',
            [
                'label' => esc_html__( 'Global Style', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'subtitle_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Subtitle Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .crypto-token-features-cards .subtitle' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typo',
				'label'    => esc_html__( 'Subtitle Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .crypto-token-features-cards .subtitle',
			]
		);

        $this->add_control(
			'title_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Title Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .crypto-token-features-cards .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'label'    => esc_html__( 'Title Typography', 'staco-core' ),
				'selector' => '{{WRAPPER}} .crypto-token-features-cards .title',
			]
		);

		$this->add_control(
			'desc',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Description Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .crypto-token-features-cards .desc' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'number',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Number Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .crypto-token-features-cards .number' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'number_text',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Number Text Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .crypto-token-features-cards .number-text' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_color',
			[
				'type'      => Controls_Manager::COLOR,
				'label'     => esc_html__( 'Number Text Color', 'staco-core' ),
				'selectors' => [
					'{{WRAPPER}} .crypto-token-features-cards .btn-text' => 'color: {{VALUE}}',
				],
			]
		);
		
        $this->add_responsive_control(
            'sec_padding',
            [
                'label' => esc_html__( 'Padding', 'rsaddon' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .crypto-token-features-cards .overlay' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
       
        $this->end_controls_section();
        
    }

    protected function render() {
		$data     = $this->get_settings();
		$template = 'view';
		$this->rt_template( $template, $data );
	}

}