<?php
/**
 * @author  UiGigs
 * @since   1.2
 * @version 1.2
 */
/*------------------------------------------------------------------------------------------------------------------*/
/* staco Demo Import
/*------------------------------------------------------------------------------------------------------------------*/

namespace UiGigs\Staco_Core;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class UiGigsDemoimport {

	//Magic Mathod
	public function __construct(){
		// Action Hook
		add_action( 'pt-ocdi/after_import', array( $this, 'uigigs_import_menu_setup' ) );
		add_action( 'pt-ocdi/after_import', array( $this, 'uigigs_import_page_setup' ) );
		add_action( 'pt-ocdi/after_import', array( $this, 'uigigs_import_page_setup' ) );

		// Filter Hook
		add_filter( 'pt-ocdi/import_files', array( $this, 'uigigs_import_files' ) );
		add_filter( 'pt-ocdi/plugin_page_setup', array( $this, 'uigigs_oneclick_admin_page' ) );
		add_filter( 'pt-ocdi/plugin_intro_text', array( $this, 'uigigs_ocdi_plugin_intro_text' ) );
		add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );
		add_filter( 'pt-ocdi/confirmation_dialog_options', array( $this, 'uigigs_ocdi_confirmation_dialog_options' ), 10, 1 );
	}

	/**
	* Demo containes file loading methos
	*/
	public function uigigs_import_files() {
		return array(
	    	//Home 1 Setup
			array(
				'import_file_name'             => 'Main Home',
				'categories'                   => array( 'Main Home' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/01.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/',
				'import_notice'                => __( 'After you import this sample-data, you will have to re save permalik.', 'staco-core' ),
			),
			//Home 2 Setup
			array(
				'import_file_name'             => 'Customer Service',
				'categories'                   => array( 'Customer Service' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/02.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/customer-service/',
			),
			//Home 3 Setup
			array(
				'import_file_name'             => 'Team Collaboration',
				'categories'                   => array( 'Team Collaboration' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/03.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/team-collaboration/',
			),
			//Home 4 Setup
			array(
				'import_file_name'             => 'SaaS Landing One',
				'categories'                   => array( 'SaaS Landing One' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/04.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/saas-landing-one/',
			),
			//Home 5 Setup
			array(
				'import_file_name'             => 'Home Sass Landing',
				'categories'                   => array( 'Home Sass Landing' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/05.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/home-sass-landing/',
			),
			//Home 6 Setup
			array(
				'import_file_name'             => 'App Landing',
				'categories'                   => array( 'App Landing' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/06.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/app-landing/',
			),
			//Home 7 Setup
			array(
				'import_file_name'             => 'Corporate Home',
				'categories'                   => array( 'Corporate Home' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/07.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/corporate-home/',
			),
			//Home 8 Setup
			array(
				'import_file_name'             => 'Crypto Wallet',
				'categories'                   => array( 'Crypto Wallet' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/08.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/crypto-wallet/',
			),
			//Home 9 Setup
			array(
				'import_file_name'             => 'Crypto Wallet 2',
				'categories'                   => array( 'Crypto Wallet 2' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/09.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/crypto-wallet-2/',
			),
			//Home 10 Setup
			array(
				'import_file_name'             => 'Crypto Token',
				'categories'                   => array( 'Crypto Token' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/10.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/crypto-token/',
			),
			//Home 11 Setup
			array(
				'import_file_name'             => 'Defi Web3',
				'categories'                   => array( 'Defi Web3' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/11.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/defi-web3/',
			),
			//Home 12 Setup
			array(
				'import_file_name'             => 'Newsletter',
				'categories'                   => array( 'Newsletter' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/12.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/newsletter/',
			),
			//Home 13 Setup
			array(
				'import_file_name'             => 'Finance',
				'categories'                   => array( 'Finance' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/13.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/finance/',
			),
			//Home 14 Setup
			array(
				'import_file_name'             => 'Home Chatbot',
				'categories'                   => array( 'Home Chatbot' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/14.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/home-chatbot/',
			),
			//Home 15 Setup
			array(
				'import_file_name'             => 'Business',
				'categories'                   => array( 'Business' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/15.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/business/',
			),
			//Home 16 Setup
			array(
				'import_file_name'             => 'Accounting',
				'categories'                   => array( 'Accounting' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/16.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/accounting/',
			),
			//Home 17 Setup
			array(
				'import_file_name'             => 'Portfolio',
				'categories'                   => array( 'Portfolio' ),
				'local_import_file'            => trailingslashit( get_template_directory() ) . 'sample-data/contents.xml',
				'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'sample-data/widgets.wie',
				'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'sample-data/customizer.dat',
				'import_preview_image_url'     => plugins_url( 'screenshots/17.jpg', dirname(__FILE__) ),
				'preview_url'                  => 'https://staco.uigaint.com/portfolio/',
			),
		);
	}

	/**
	* Assign menus to their locations.
	*/
	public function uigigs_import_menu_setup( $selected_import ) {
		$main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );
		$one_page = get_term_by( 'name', 'One Page Menu', 'nav_menu' );
		$footer_menu = get_term_by( 'name', 'Footer Menu', 'nav_menu' );
		$footer_menu2 = get_term_by( 'name', 'Copy Right Menu', 'nav_menu' );
		set_theme_mod( 'nav_menu_locations', array(
			'primary' => $main_menu->term_id,
			'copyright_menu' => $footer_menu2->term_id,
		));
	}

	/**
	* Assign front page and posts page (blog page).
	*/
	public function uigigs_import_page_setup( $selected_import ) {

	    // Assign front page and posts page (blog page).
		if ( 'Main Home' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "home", OBJECT, array( 'page' ) );
		} elseif ( 'Customer Service' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "customer-service", OBJECT, array( 'page' ) );
		} elseif ( 'Team Collaboration' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "team-collaboration", OBJECT, array( 'page' ) );
		} elseif ( 'SaaS Landing One' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "saas-landing-one", OBJECT, array( 'page' ) );
		} elseif ( 'Home Sass Landing' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "home-sass-landing", OBJECT, array( 'page' ) );
		} elseif ( 'App Landing' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "app-landing", OBJECT, array( 'page' ) );
		} elseif ( 'Corporate Home' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "corporate-home", OBJECT, array( 'page' ) );
		} elseif ( 'Crypto Wallet' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "crypto-wallet", OBJECT, array( 'page' ) );
		} elseif ( 'Crypto Wallet 2' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "crypto-wallet-2", OBJECT, array( 'page' ) );
		} elseif ( 'Crypto Token' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "crypto-token", OBJECT, array( 'page' ) );
		} elseif ( 'Defi Web3' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "defi-web3", OBJECT, array( 'page' ) );
		} elseif ( 'Newsletter' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "newsletter", OBJECT, array( 'page' ) );
		} elseif ( 'Finance' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "finance", OBJECT, array( 'page' ) );
		} elseif ( 'Home Chatbot' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "home-chatbot", OBJECT, array( 'page' ) );
		} elseif ( 'Business' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "business", OBJECT, array( 'page' ) );
		} elseif ( 'Accounting' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "accounting", OBJECT, array( 'page' ) );
		} elseif ( 'Portfolio' === $selected_import['import_file_name'] ) {
			$front_page_id = get_page_by_path( "portfolio", OBJECT, array( 'page' ) );
		} else {
			$front_page_id = get_page_by_path( "home", OBJECT, array( 'page' ) );
		}
		update_option( 'show_on_front', 'page' );
		update_option( 'page_on_front', $front_page_id->ID );   

		$blog_page_id  = get_page_by_path( "blog", OBJECT, array( 'page' ) );
		update_option( 'page_for_posts', $blog_page_id->ID ); 
	}

	/**
	* Install Demos Menu - Menu Edited
	*/
	public function uigigs_oneclick_admin_page( $default_settings ) {
		$default_settings['parent_slug'] = 'themes.php';
		$default_settings['page_title']  = esc_html__( 'Install Demos', 'staco-core' );
		$default_settings['menu_title']  = esc_html__( 'Install Demos', 'staco-core' );
		$default_settings['capability']  = 'import';
		$default_settings['menu_slug']   = 'install_demos';
		return $default_settings;
	}


	// Model Popup - Width Increased
	public function uigigs_ocdi_confirmation_dialog_options ( $options ) {
	  return array_merge( $options, array(
	    'width'       => 600,
	    'dialogClass' => 'wp-dialog',
	    'resizable'   => false,
	    'height'      => 'auto',
	    'modal'       => true,
	  ) );
	}

	public function uigigs_ocdi_plugin_intro_text( $default_text ) {
		$auto_install = admin_url('themes.php?page=install_demos');
		$manual_install = admin_url('themes.php?page=install_demos&import-mode=manual');
		$default_text .= '<h1>Install Demos</h1>
		<div class="uigigs-core_intro-text vtdemo-one-click">
		<div id="poststuff">

		<div class="postbox important-notes">
		<h3><span>Important notes:</span></h3>
		<div class="inside">
		<ol>
		<li>Please note, this import process will take time. So, please be patient.</li>
		<li>Please make sure you\'ve installed recommended plugins before you import this content.</li>
		<li>All images are demo purposes only. So, images may repeat in your site content.</li>
		</ol>
		</div>
		</div>

		<div class="postbox vt-support-box vt-error-box">
		<h3><span>Don\'t Edit Parent Theme Files:</span></h3>
		<div class="inside">
		<p>Don\'t edit any files from parent theme! Use only a <strong>Child Theme</strong> files for your customizations!</p>
		<p>If you get future updates from our theme, you\'ll lose edited customization from your parent theme.</p>
		</div>
		</div>

		<div class="postbox vt-support-box">
		<h3><span>Need Support?</span> <a href="https://themeforest.net/user/uigigs" target="_blank" class="cs-section-video"><i class="fas fa-hand-point-right"></i> <span>How to?</span></a></h3>
		<div class="inside">
		<p>Have any doubts regarding this installation or any other issues? Please feel free to send us a mail to our support stuff mail support@uigigs.com</p>
		<a href="https://www.uigigs.com/demo/wordpress/themes/staco/docs/" class="button-primary" target="_blank">Docs</a>
		<a href="https://themeforest.net/user/uigigs/" class="button-primary" target="_blank">Support</a>
		<a href="https://themeforest.net/item/uigigs/123?ref=uigigs" class="button-primary" target="_blank">Item Page</a>
		</div>
		</div>
		<div class="nav-tab-wrapper vt-nav-tab">
		<a href="'. $auto_install .'" class="nav-tab vt-mode-switch vt-auto-mode nav-tab-active">Auto Import</a>
		<a href="'. $manual_install .'" class="nav-tab vt-mode-switch vt-manual-mode">Manual Import</a>
		</div>

		</div>
		</div>';

		return $default_text;
	}

} //End Of Class

$uigigs_init = new UiGigsDemoimport(); //Initialization of class
