<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

use UiGigs\staco\staco;

if ( ! defined( 'ABSPATH' ) ) exit;

if ( !class_exists( 'staco_Postmeta' ) ) {
	return;
}

$Postmeta = \staco_Postmeta::getInstance();

$prefix = Staco_Core_THEME_PREFIX;

$ctp_socials = array(
	'facebook' => array(
		'label' => __( 'Facebook', 'staco-core' ),
		'type'  => 'text',
		'icon'  => 'fab fa-facebook-f',
		'color' => '#3b5998',
	),
	'twitter' => array(
		'label' => __( 'Twitter', 'staco-core' ),
		'type'  => 'text',
		'icon'  => 'fab fa-twitter',
		'color' => '#1da1f2',
	),
	'linkedin' => array(
		'label' => __( 'Linkedin', 'staco-core' ),
		'type'  => 'text',
		'icon'  => 'fab fa-linkedin-in',
		'color' => '#0077b5',
	),
	'instagram' => array(
		'label' => __( 'Instagram', 'staco-core' ),
		'type'  => 'text',
		'icon'  => 'fab fa-instagram',
		'color' => '#AA3DB2',
	),
	'pinterest' => array(
		'label' => __( 'Pinterest', 'staco-core' ),
		'type'  => 'text',
		'icon'  => 'fab fa-pinterest-p',
		'color' => '#E60023',
	),
);
$staco_ctp_socials = apply_filters( 'ctp_socials', $ctp_socials );

/*---------------------------------------------------------------------
#. = Layout Settings
-----------------------------------------------------------------------*/
$nav_menus = wp_get_nav_menus( array( 'fields' => 'id=>name' ) );
$nav_menus = array( 'default' => __( 'Default', 'staco-core' ) ) + $nav_menus;

$Postmeta->add_meta_box( "{$prefix}_page_settings", __( 'Layout Settings', 'staco-core' ), array( 'page', 'post', 'artex_team' ), '', '', 'high', array(
	'fields' => array(
	
		"{$prefix}_layout_settings" => array(
			'label'   => __( 'Layouts', 'staco-core' ),
			'type'    => 'group',
			'value'  => array(	
			
				"{$prefix}_layout" => array(
					'label'   => __( 'Layout', 'staco-core' ),
					'type'    => 'select',
					'options' => array(
						'default'       => __( 'Default', 'staco-core' ),
						'full-width'    => __( 'Full Width', 'staco-core' ),
						'left-sidebar'  => __( 'Left Sidebar', 'staco-core' ),
						'right-sidebar' => __( 'Right Sidebar', 'staco-core' ),
					),
					'default'  => 'default',
				),		
				"{$prefix}_page_menu" => array(
					'label'    => __( 'Main Menu', 'staco-core' ),
					'type'     => 'select',
					'options'  => $nav_menus,
					'default'  => 'default',
				),
				"{$prefix}_tr_header" => array(
					'label'    	  => __( 'Transparent Header', 'staco-core' ),
					'type'     	  => 'select',
					'options'  	  => array(
						'default' => __( 'Default', 'staco-core' ),
						'on'      => __( 'Enabled', 'staco-core' ),
						'off'     => __( 'Disabled', 'staco-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_header_area" => array(
					'label' 	  => __( 'Header Area', 'staco-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'staco-core' ),
						'on'      => __( 'Enabled', 'staco-core' ),
						'off'     => __( 'Disabled', 'staco-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_footer_area" => array(
					'label' 	  => __( 'Footer Area', 'staco-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'staco-core' ),
						'on'      => __( 'Enabled', 'staco-core' ),
						'off'     => __( 'Disabled', 'staco-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_footer" => array(
					'label'   => __( 'Footer Layout', 'staco-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'staco-core' ),
						'1'       => __( 'Layout 1', 'staco-core' ),
						'2'       => __( 'Layout 2', 'staco-core' ),
						'3'       => __( 'Layout 3', 'staco-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_copyright_area" => array(
					'label' 	  => __( 'Copyright Area', 'staco-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'staco-core' ),
						'on'      => __( 'Enabled', 'staco-core' ),
						'off'     => __( 'Disabled', 'staco-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_banner" => array(
					'label'   => __( 'Banner', 'staco-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'staco-core' ),
						'on'	  => __( 'Enable', 'staco-core' ),
						'off'	  => __( 'Disable', 'staco-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_breadcrumb" => array(
					'label'   => __( 'Breadcrumb', 'staco-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'staco-core' ),
						'on'      => __( 'Enable', 'staco-core' ),
						'off'	  => __( 'Disable', 'staco-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_banner_type" => array(
					'label'   => __( 'Banner Background Type', 'staco-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'staco-core' ),
						'bgimg'   => __( 'Background Image', 'staco-core' ),
						'bgcolor' => __( 'Background Color', 'staco-core' ),
					),
					'default' => 'default',
				),

				"{$prefix}_banner_bgimg" => array(
					'label' => __( 'Banner Background Image', 'staco-core' ),
					'type'  => 'image',
					'desc'  => __( 'If not selected, default will be used', 'staco-core' ),
				),
				"{$prefix}_banner_bgcolor" => array(
					'label' => __( 'Banner Background Color', 'staco-core' ),
					'type'  => 'color_picker',
					'desc'  => __( 'If not selected, default will be used', 'staco-core' ),
				),
				"{$prefix}_banner_bgopacity" => array(
					'label' => esc_html__( 'Background Opacity', 'evacon-core' ),
					'type'  => 'number',
					'default'  => '',
					'desc'  => esc_html__( 'Max input number will be 100', 'evacon-core' ),
				),
				"{$prefix}_top_padding" => array(
					'label'   => __( 'Banner Padding Top', 'staco-core' ),
					'type'    => 'number',
					'default'  => '170',
				),
				"{$prefix}_bottom_padding" => array(
					'label'   => __( 'Banner Padding Bottom', 'staco-core' ),
					'type'    => 'number',
					'default'  => '120',
				),
			)
		)
	),
) );

/*---------------------------------------------------------------------
#. = Speaker
-----------------------------------------------------------------------*/
$Postmeta->add_meta_box( $prefix.'_speaker_info', __( 'Speaker Information', 'staco-core' ), array( $prefix.'_speaker' ), '', '', 'high', array(
	'fields' => array(
		"{$prefix}_speaker_desigantion" => array(
			'label' => esc_html__( 'Designation', 'staco-core' ),
			'type'  => 'text',
		),
		"{$prefix}_speaker_socials" => array(
			'type'  => 'group',
			'label' => esc_html__( 'Speaker Socials', 'artex-core' ),
			'value'  => $staco_ctp_socials
		),
	)
) );