<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\Staco_Core;

class Custom_Widgets_Init {

	public $widgets;
	protected static $instance = null;
	public function __construct() {
		$sidebar_widgets = array(
			'post'     	  => 'Post_Widget',
		);
		$footer_widgets = array(
			'about'    	 => 'About_Widget',
			'newsletter' => 'Newsletter_Widget',
		);
		$this->widgets = array_merge( $sidebar_widgets, $footer_widgets );

		add_action( 'widgets_init', array( $this, 'custom_widgets' ) );
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}

	public function staco_event_widgets() {
		register_sidebar( array(
			'name'          => esc_html__( 'Event Widgets', 'staco-core' ),
			'id'            => 'event-widgets',
			'description'   => esc_html__('Service details page widgets area', 'staco-core'),
			'before_widget' => '<div id="%1$s" class="widget %2$s sidebar-widget service-widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="widget-heading heading-dark"><h4 class="heading-title">',
			'after_title'   => '</h4></div>',
		) );

		if ( class_exists( 'woocommerce' ) ) {
			register_sidebar( array(
				'name'          => esc_html__( 'Products Page', 'staco-core' ),
				'id'            => 'product-archive',
				'description'   => esc_html__('Products Page Sidebar widgets', 'staco-core'),
				'before_widget' => '<div id="%1$s" class="widget %2$s sidebar-widget">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="widget-heading heading-dark"><h4 class="heading-title">',
				'after_title'   => '</h4></div>',
			) );
			register_sidebar( array(
				'name'          => esc_html__( 'Products Details', 'staco-core' ),
				'id'            => 'product-details',
				'description'   => esc_html__('Products Details Page Sidebar widgets', 'staco-core'),
				'before_widget' => '<div id="%1$s" class="widget %2$s sidebar-widget">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="widget-heading heading-dark"><h4 class="heading-title">',
				'after_title'   => '</h4></div>',
			) );
		}
			
	}

	public function custom_widgets() {
		if ( !class_exists( 'staco_Widget_Fields' ) ) return;

		foreach ( $this->widgets as $filename => $classname ) {
			$file  = dirname(__FILE__) . '/' . $filename . '.php';
			$class = __NAMESPACE__ . '\\' . $classname;
			require_once $file;
			register_widget( $class );
		}
	}
}

Custom_Widgets_Init::instance();