<?php
/**
 * Plugin Name: UIGIGs Elementor Header & Footer Builder
 * Plugin URI:  https://themeforest.net/user/uigigs/portfolio
 * Description: UIGIGs header footer builder
 * Author:      UIGIGs The
 * Author URI:  https://themeforest.net/user/uigigs/portfolio
 * Text Domain: uigigs-header-footer-elementor
 * Domain Path: /languages
 * Version: 1.0.0
 */

define( 'UIGIGSHFE_VER', '1.0.0' );
define( 'UIGIGSHFE_FILE', __FILE__ );
define( 'UIGIGSHFE_DIR', plugin_dir_path( __FILE__ ) );
define( 'UIGIGSHFE_URL', plugins_url( '/', __FILE__ ) );
define( 'UIGIGSHFE_PATH', plugin_basename( __FILE__ ) );
define( 'UIGIGSHFE_DOMAIN', trailingslashit( 'https://themeforest.net/user/uigigs/portfolio' ) );
define( 'UIGIGSHFE_DIR_URL_ADMIN', plugin_dir_url( __FILE__ ) );
define( 'UIGIGSHFE_ASSETS_ADMIN', trailingslashit( UIGIGSHFE_DIR_URL_ADMIN ) );


/**
 * Load the class loader.
 */
require_once UIGIGSHFE_DIR . '/inc/class-header-footer-elementor.php';

/**
 * Load the Plugin Class.
 */
function uigigshfe_plugin_activation() {

	$footer_widget = hfe_footer_widget_func();
	update_option( 'hfe_plugin_is_activated', 'yes' );
	update_option( 'uigigshfe_addon_option', $footer_widget );
}
register_activation_hook( UIGIGSHFE_FILE, 'uigigshfe_plugin_activation' );

/**
 * Load the Plugin Class.
 */
function uigigshfe_init() {
	Header_Footer_Elementor::instance();
}
add_action( 'plugins_loaded', 'uigigshfe_init' );

function hfe_footer_widget_func() {
	$array = [
		'uigigshfe_copyright' => 'uigigshfe_copyright',
		'uigigshfe_header_button' => 'uigigshfe_header_button',
		'uigigshfe_navigation_menu' => 'uigigshfe_navigation_menu' ,
		'uigigshfe_site_logo' => 'uigigshfe_site_logo',
		'uigigshfe_page_title' => 'uigigshfe_page_title',
		'uigigshfe_search' => 'uigigshfe_search'
	];

	return $array;
}
