<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

// namespace UiGigs\staco;
use UiGigs\staco\staco;

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>

    <?php
        if (staco::$options['preloader']) {
            do_action('site_prealoader');
        }
    ?>

	<div id="wrapper" class="wrapper">
		<div id="main_content">
			<!--=====================================-->
			<!--=           404 Area Start          =-->
			<!--=====================================-->
			<section class="error-wrap-layout section-padding bg-image">
				<div class="container">
					<div class="item-logo">
						<?php get_template_part( 'template-parts/header/logo', 1 ); ?>
					</div>
					<h1 class="main-title"><?php echo esc_html( staco::$options['error_page_title'] ); ?></h1>
					<h2 class="sub-title"><?php echo esc_html( staco::$options['error_page_subtitle'] ); ?></h2>	
					<?php get_search_form(); ?>
					<div class="error-page-btn">
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="item-btn btn-fill style-one" tabindex="0"><?php echo esc_html( staco::$options['error_buttontext'] );?></a>
                    </div>
				</div>	
			</section>
			<!--=====================================-->
			<!--=           404 Area End            =-->
			<!--=====================================-->			
		</div>
	</div>

	<?php wp_footer(); ?>

</body>
</html>