<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */

namespace UiGigs\staco;

if ( post_password_required() ) {
    return;
}
?>
<div id="comments" class="comments-area single-blog-form">
    <?php if ( have_comments() ): ?>
    <div class="blog-comment">
        <?php
            $stacotheme_comment_count = get_comments_number();
            $stacotheme_comments_text = number_format_i18n( $stacotheme_comment_count ) ;
            if ( $stacotheme_comment_count > 1 ) {
                $stacotheme_comments_text .= esc_html__( ' Comments', 'staco' );
            }
            else{
                $stacotheme_comments_text .= esc_html__( ' Comment', 'staco' );
            }
        ?>
        <h3 class="comment-title"><?php echo esc_html( $stacotheme_comments_text );?></h3>
        <?php $stacotheme_avatar = get_option( 'show_avatars' ); ?>
        <ul class="comment-list<?php echo empty( $stacotheme_avatar ) ? ' avatar-disabled' : '';?>">
            <?php
                wp_list_comments(
                    array(
                        'style'        => 'ul',
                        'callback'     => 'UiGigs\staco\Helper::comments_callback',
                        'reply_text'   => esc_html__( 'Reply', 'staco' ),
                        'avatar_size'  => 70,
                        'format'       => 'html5'
                    ) 
                );
            ?>
        </ul>

        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :?>
            <nav class="pagination-area comment-pagination">
                <ul>
                    <li class="older-comments"><?php previous_comments_link( esc_html__( 'Older Comments', 'staco' ) ); ?></li>
                    <li class="newer-comments"><?php next_comments_link( esc_html__( 'Newer Comments', 'staco' ) ); ?></li>
                </ul>
            </nav>
        <?php endif;?>
    </div>
    <?php endif;?>
    
    <?php if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
        <p class="comments-closed"><?php esc_html_e( 'Comments are closed.', 'staco' ); ?></p>
    <?php endif; ?>

    <?php
    // Start displaying Comment Form
    $stacotheme_commenter = wp_get_current_commenter();		
    $stacotheme_req = get_option( 'require_name_email' );
    $stacotheme_aria_req = ( $stacotheme_req ? " required" : '' );


    $stacotheme_fields =  array(
        '<div class="row">
            <div class="col-sm-6"><div class="form-group">',
                'author' => '
                <input id="author" class="form-control form-input" name="author" value="' . esc_attr( $stacotheme_commenter['comment_author'] ) . '" type="text" placeholder="'.esc_attr__( 'Type your name...', 'staco' ).'" size="30"' . $stacotheme_aria_req . '/>
            </div></div>
            <div class="col-sm-6"><div class="form-group">',
                'email'  => '
                <input id="email" class="form-control form-input" name="email" value="' . esc_attr(  $stacotheme_commenter['comment_author_email'] ) . '" type="email" placeholder="'.esc_attr__( 'Type your email...', 'staco' ).'" size="30"' . $stacotheme_aria_req . '/>
            </div></div>
        </div>',
    );

    $stacotheme_args = array(
        'submit_field'  => '<div class="form-submit">%1$s %2$s</div>',
        'title_reply'   => esc_html__( 'Leave a Comment', 'staco' ),
        'submit_button' => '<div class="form-btn"><button type="submit" class="bg-blue-btn site_btn">'.esc_attr__( 'Post Comment', 'staco' ).'<span class="hover_overlay"></span></button></div>',
        'comment_field' =>  '<div class="form-group comment-form-comment"><textarea id="comment" name="comment" required placeholder="'.esc_attr__( 'Your Comment *', 'staco' ).'" class="textarea form-control" rows="6" cols="20"></textarea></div>',
        'fields' => apply_filters( 'comment_form_default_fields', $stacotheme_fields ),
    );
    ?>
    <div class="reply-separator"></div>
    <?php comment_form( $stacotheme_args );?>
</div>