<?php

/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
use UiGigs\staco\staco;
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>

    <?php
        if (staco::$options['preloader']) {
            do_action('site_prealoader');
        }
    ?>

    <div id="wrapper" class="wrapper overflow-hidden">
        <?php if ( staco::$header_area == 1 || staco::$header_area === "on" ){ ?>
        <div id="masthead" class="site-header">
            <?php get_template_part('template-parts/header/header', staco::$header_style ); ?>
        </div>
        <?php get_template_part('template-parts/header/mobile', 'menu'); ?>
        <?php }
            if ( staco::$has_banner == '1' || staco::$has_banner != "off" ) {
                get_template_part( 'template-parts/content', 'banner' ); 
            }
            
        ?>