<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\staco\Customizer;
/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class staco_Customizer {
	// Get our default values
	protected $defaults;
    protected static $instance = null;

	public function __construct() {
		// Register Panels
		add_action( 'customize_register', array( $this, 'add_customizer_panels' ) );
		// Register sections
		add_action( 'customize_register', array( $this, 'add_customizer_sections' ) );
	}

    public static function instance() {
        if (null == self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function populated_default_data() {
        $this->defaults = uigtheme_generate_defaults();
    }

	/**
	 * Customizer Panels
	 */
	public function add_customizer_panels( $wp_customize ) {

        // Add Header Panel
        $wp_customize->add_panel( 'uigtheme_header_settings',
            array(
                'title' => esc_html__( 'Header', 'staco' ),
                'description' => esc_html__( 'Headers.', 'staco' ),
                'priority' => 3,
            )
        );

        // Add Footer Panel
        $wp_customize->add_panel( 'uigtheme_footer_settings',
            array(
                'title' => esc_html__( 'Footer', 'staco' ),
                'description' => esc_html__( 'Footers.', 'staco' ),
                'priority' => 4,
            )
        );

        // Add Color Panel
        $wp_customize->add_panel( 'uigtheme_colors_defaults',
            array(
                'title' => esc_html__( 'Color Settings', 'staco' ),
                'description' => esc_html__( 'staco overall colors for your site.', 'staco' ),
                'priority' => 5,
            )
        );

	    // Add Laypout Panel
		$wp_customize->add_panel( 'uigtheme_layouts_defaults',
	        array(
				'title' => esc_html__( 'Layout Settings', 'staco' ),
				'description' => esc_html__( 'Adjust the overall layout for your site.', 'staco' ),
				'priority' => 6,
			)
		);

        // Add Blog Panel
        $wp_customize->add_panel( 'uigtheme_blog_settings',
            array(
                'title' => esc_html__( 'Blog Settings', 'staco' ),
                'description' => esc_html__( 'Blog settings for your site.', 'staco' ),
                'priority' => 7,
            )
        );

        // Add General Panel
        $wp_customize->add_panel( 'uigtheme_cpt_settings',
            array(
                'title' => esc_html__( 'Custom Posts', 'staco' ),
                'description' => esc_html__( 'All custom posts settings here.', 'staco' ),
                'priority' => 8,
            )
        );
	}

    /**
    * Customizer sections
    */
	public function add_customizer_sections( $wp_customize ) {

		// Rename the default Colors section
		$wp_customize->get_section( 'colors' )->title = 'Background';

		// Move the default Colors section to our new Colors Panel
		$wp_customize->get_section( 'colors' )->panel = 'colors_panel';

		// Change the Priority of the default Colors section so it's at the top of our Panel
		$wp_customize->get_section( 'colors' )->priority = 10;

		// Add General Section
		$wp_customize->add_section( 'general_section',
			array(
				'title' => esc_html__( 'General', 'staco' ),
				'priority' => 1,
			)
		);

        // Add Contact Section
        $wp_customize->add_section( 'contact_section',
            array(
                'title' => esc_html__( 'Socials', 'staco' ),
                'priority' => 2,
            )
        );

		// Add Header Main Section
		$wp_customize->add_section( 'header_section',
			array(
				'title' => esc_html__( 'Header', 'staco' ),
				'priority' => 3,
			)
		);
        // Add Header Common
        $wp_customize->add_section( 'header_common',
            array(
                'title' => esc_html__( 'All Header', 'staco' ),
                'priority' => 1,
                'panel' => 'uigtheme_header_settings',
            )
        );
        // Add Header Mobile
        $wp_customize->add_section( 'header_mobile_section',
            array(
                'title' => esc_html__( 'Header Mobile', 'staco' ),
                'priority' => 3,
                'panel' => 'uigtheme_header_settings',
            )
        );
        // Add Header Banner
        $wp_customize->add_section( 'header_banner_section',
            array(
                'title' => esc_html__( 'Header Banner', 'staco' ),
                'priority' => 4,
                'panel' => 'uigtheme_header_settings',
            )
        );
        // Add Header Toggle
        $wp_customize->add_section( 'header_toggle_section',
            array(
                'title' => esc_html__( 'Header Toggle', 'staco' ),
                'priority' => 5,
                'panel' => 'uigtheme_header_settings',
            )
        );

        // Add Footer Common
        $wp_customize->add_section( 'footer_common',
            array(
                'title' => esc_html__( 'All Footer', 'staco' ),
                'priority' => 1,
                'panel' => 'uigtheme_footer_settings',
            )
        );
        // Add Footer 1
        $wp_customize->add_section( 'footer_1',
            array(
                'title' => esc_html__( 'Footer 1', 'staco' ),
                'priority' => 2,
                'panel' => 'uigtheme_footer_settings',
            )
        );
        // Add Footer 2
        $wp_customize->add_section( 'footer_2',
            array(
                'title' => esc_html__( 'Footer 2', 'staco' ),
                'priority' => 3,
                'panel' => 'uigtheme_footer_settings',
            )
        );
        // Add Footer 3
        $wp_customize->add_section( 'call_to_action',
            array(
                'title' => esc_html__( 'Call To Action', 'staco' ),
                'priority' => 4,
                'panel' => 'uigtheme_footer_settings',
            )
        );
        // Add Color Section
        $wp_customize->add_section( 'site_color_section',
            array(
                'title' => esc_html__( 'Site Base Color', 'staco' ),
                'priority' => 1,
                'panel' => 'uigtheme_colors_defaults',
            )
        );
        $wp_customize->add_section( 'menu_color_section',
            array(
                'title' => esc_html__( 'Transparent Menu Color', 'staco' ),
                'priority' => 2,
                'panel' => 'uigtheme_colors_defaults',
            )
        );
        $wp_customize->add_section( 'menu2_color_section',
            array(
                'title' => esc_html__( 'Non Transparent Menu Color', 'staco' ),
                'priority' => 3,
                'panel' => 'uigtheme_colors_defaults',
            )
        );
        $wp_customize->add_section( 'others_color_section',
            array(
                'title' => esc_html__( 'Others Color', 'staco' ),
                'priority' => 4,
                'panel' => 'uigtheme_colors_defaults',
            )
        );
        $wp_customize->add_section( 'dark_layout_color_section',
            array(
                'title' => esc_html__( 'Dark Layout Color', 'staco' ),
                'priority' => 4,
                'panel' => 'uigtheme_colors_defaults',
            )
        );

        // Add Pages Layout Section
        $wp_customize->add_section( 'page_layout_section',
            array(
                'title' => esc_html__( 'Pages Layout', 'staco' ),
                'priority' => 1,
                'panel' => 'uigtheme_layouts_defaults',
            )
        );
        // Add Single posts/Pages Layout Section
        $wp_customize->add_section( 'blog_layout_section',
            array(
                'title' => esc_html__( 'Blog Archive Layout', 'staco' ),
                'priority' => 2,
                'panel' => 'uigtheme_layouts_defaults',
            )
        );
        // Add Single posts/Pages Layout Section
        $wp_customize->add_section( 'post_single_layout_section',
            array(
                'title' => esc_html__( 'Single Post Layout', 'staco' ),
                'priority' => 3,
                'panel' => 'uigtheme_layouts_defaults',
            )
        );

        // Add Search Layout Section
        $wp_customize->add_section( 'search_layout_section',
            array(
                'title' => __( 'Search Layout', 'staco' ),
                'priority' => 4,
                'panel' => 'uigtheme_layouts_defaults',
            )
        );
        
        // Add Error Layout Section
        $wp_customize->add_section( 'error_layout_section',
            array(
                'title' => __( 'Error Layout', 'staco' ),
                'priority' => 5,
                'panel' => 'uigtheme_layouts_defaults',
            )
        );

        // Add Blog Settings Section
        $wp_customize->add_section( 'blog_post_settings_section',
            array(
                'title' => esc_html__( 'Blog Settings', 'staco' ),
                'priority' => 8,
                'panel' => 'uigtheme_blog_settings',
            )
        );
        // Add Single Blog Settings Section
        $wp_customize->add_section( 'single_post_secttings_section',
            array(
                'title' => esc_html__( 'Single Post Settings', 'staco' ),
                'priority' => 9,
                'panel' => 'uigtheme_blog_settings',
            )
        );

        // Add Event Section
        $wp_customize->add_section( 'event_section',
            array(
                'title' => esc_html__( 'Event', 'staco' ),
                'priority' => 1,
                'panel' => 'uigtheme_cpt_settings',
            )
        );
        // Add Service Section
        $wp_customize->add_section( 'speaker_section',
            array(
                'title' => esc_html__( 'Speaker', 'staco' ),
                'priority' => 10,
                'panel' => 'uigtheme_cpt_settings',
            )
        );

          // Add Portfolio Section
        $wp_customize->add_section( 'portfolio_section',
            array(
                'title' => esc_html__( 'Portfolio', 'staco' ),
                'priority' => 11,
                'panel' => 'uigtheme_cpt_settings',
            )
        );

        // Add Error Page Section
        $wp_customize->add_section( 'error_section',
            array(
                'title' => esc_html__( 'Error Page', 'staco' ),
                'priority' => 12,
            )
        );
	}
}
