<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\staco\Customizer\Settings;

use UiGigs\staco\Customizer\staco_Customizer;
use UiGigs\staco\Customizer\Controls\Customizer_Switch_Control;
use UiGigs\staco\Customizer\Controls\Customizer_Image_Radio_Control;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class staco_Blog_Post_Settings extends staco_Customizer {

	public function __construct() {
	    parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_blog_post_controls' ) );
	}

    /**
     * Blog Post Controls
     */
    public function register_blog_post_controls( $wp_customize ) {

        // Blog Post Style
        $wp_customize->add_setting( 'blog_style',
            array(
                'default' => $this->defaults['blog_style'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_radio_sanitization'
            )
        );
        $wp_customize->add_control( new Customizer_Image_Radio_Control( $wp_customize, 'blog_style',
            array(
                'label' => esc_html__( 'Post Layout', 'staco' ),
                'description' => esc_html__( 'Blog Post layout grid or list.', 'staco' ),
                'section' => 'blog_post_settings_section',
                'choices' => array(
                    '1' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/blog2.jpg',
                        'name' => esc_html__( 'List Layout', 'staco' )
                    ),
                    '2' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/blog1.jpg',
                        'name' => esc_html__( 'Grid Layout 1', 'staco' )
                    ),
                )
            )
        ) );


        // Blog Grid Columns
        $wp_customize->add_setting( 'blog_grid',
            array(
                'default' => $this->defaults['blog_grid'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_radio_sanitization'
            )
        );
        $wp_customize->add_control( 'blog_grid',
            array(
                'label' => esc_html__( 'Grid layput Columns', 'staco' ),
                'section' => 'blog_post_settings_section',
                'description' => esc_html__( 'This grid system work only for post layout 2', 'staco' ),
                'type' => 'select',
                'choices' => array(
                    '12' => esc_html__( '1 Column', 'staco' ),
                    '6' => esc_html__( '2 Columns', 'staco' ),
                    '4' => esc_html__( '3 Columns', 'staco' ),
                    '3' => esc_html__( '4 Columns', 'staco' ),
                    '2' => esc_html__( '6 Columns', 'staco' ),
                ),
                'active_callback' => 'uigtheme_blog_cols_condition',
            )
        );

        // Post Admin
        $wp_customize->add_setting( 'post_meta_admin',
            array(
                'default' => $this->defaults['post_meta_admin'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'post_meta_admin',
            array(
                'label' => esc_html__( 'Display Meta Admin', 'staco' ),
                'section' => 'blog_post_settings_section',
            )
        ) );

        // Post Date
        $wp_customize->add_setting( 'post_meta_date',
            array(
                'default' => $this->defaults['post_meta_date'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'post_meta_date',
            array(
                'label' => esc_html__( 'Display Meta Date', 'staco' ),
                'section' => 'blog_post_settings_section',
            )
        ) );

        // Post Commnents
        $wp_customize->add_setting( 'post_meta_comnt',
            array(
                'default' => $this->defaults['post_meta_comnt'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'post_meta_comnt',
            array(
                'label' => esc_html__( 'Display Meta Commnets', 'staco' ),
                'section' => 'blog_post_settings_section',
            )
        ) );

        // Post Categories
        $wp_customize->add_setting( 'post_meta_cats',
            array(
                'default' => $this->defaults['post_meta_cats'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'post_meta_cats',
            array(
                'label' => esc_html__( 'Display Meta Category', 'staco' ),
                'section' => 'blog_post_settings_section',
            )
        ));

        // Excerpt Length
        $wp_customize->add_setting( 'excerpt_length',
            array(
                'default' => $this->defaults['excerpt_length'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_sanitize_integer'
            )
        );
        $wp_customize->add_control( 'excerpt_length',
            array(
                'label' => esc_html__( 'Excerpt Length', 'staco' ),
                'section' => 'blog_post_settings_section',
                'type' => 'number'
            )
        );

    }

}

/**
 * Initialise our Customizer settings only when they're required
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new staco_Blog_Post_Settings();
}
