<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\staco\Customizer\Settings;

use UiGigs\staco\Customizer\staco_Customizer;
use UiGigs\staco\Customizer\Controls\Customizer_Switch_Control;
use UiGigs\staco\Customizer\Controls\Customizer_Gallery_Control;
use UiGigs\staco\Customizer\Controls\Customizer_Heading_Control;
use UiGigs\staco\Customizer\Controls\Customizer_Heading_Control2;
use UiGigs\staco\Customizer\Controls\Customizer_Image_Radio_Control;
use WP_Customize_Media_Control;
use WP_Customize_Color_Control;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class staco_Call_To_Action_Settings extends staco_Customizer {

	public function __construct() {
	    parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_call_to_action_controls' ) );
	}

    public function register_call_to_action_controls( $wp_customize ) {

        /*  Call To Action
        * =======================================================================*/
        // Add our checkbox switch setting
        $wp_customize->add_setting( 'cta_switch',
            array(
                'default' => $this->defaults['cta_switch'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'cta_switch',
            array(
                'label' => esc_html__( 'Call To Action', 'staco' ),
                'section' => 'call_to_action',
            )
        ) );
        /* Title
        * ======================*/
        $wp_customize->add_setting( 'cta_title',
            array(
                'default' => $this->defaults['cta_title'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'cta_title',
            array(
                'label' => esc_html__( 'Title', 'staco' ),
                'section' => 'call_to_action',
                'type' => 'text',
            )
        );
        /* Button 1
        * ======================*/
        $wp_customize->add_setting( 'cta_btn1_text',
            array(
                'default' => $this->defaults['cta_btn1_text'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'cta_btn1_text',
            array(
                'label' => esc_html__( 'Button 1 Text', 'staco' ),
                'section' => 'call_to_action',
                'type' => 'text',
            )
        );
        $wp_customize->add_setting( 'cta_btn1_link',
            array(
                'default' => $this->defaults['cta_btn1_link'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'cta_btn1_link',
            array(
                'label' => esc_html__( 'Button 1 Link', 'staco' ),
                'section' => 'call_to_action',
                'type' => 'text',
            )
        );

        /* Button 2
        * ======================*/
        $wp_customize->add_setting( 'cta_btn2_text',
            array(
                'default' => $this->defaults['cta_btn2_text'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'cta_btn2_text',
            array(
                'label' => esc_html__( 'Button 2 Text', 'staco' ),
                'section' => 'call_to_action',
                'type' => 'text',
            )
        );
        $wp_customize->add_setting( 'cta_btn2_link',
            array(
                'default' => $this->defaults['cta_btn2_link'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'cta_btn2_link',
            array(
                'label' => esc_html__( 'Button 2 Link', 'staco' ),
                'section' => 'call_to_action',
                'type' => 'text',
            )
        );

    }

}

/**
 * Initialise our Customizer settings only when they're required
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new staco_Call_To_Action_Settings();
}
