<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\staco\Customizer\Settings;

use UiGigs\staco\Customizer\staco_Customizer;
use UiGigs\staco\Customizer\Controls\Customizer_Switch_Control;
use UiGigs\staco\Customizer\Controls\Customizer_Heading_Control2;
use UiGigs\staco\Customizer\Controls\Customizer_Separator_Control;
use WP_Customize_Media_Control;
use WP_Customize_Color_Control;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class staco_Colors_Settings extends staco_Customizer {

	public function __construct() {
        parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_general_controls' ) );
	}

    public function register_general_controls( $wp_customize ) {

        /**
        * Site Base Color Controls
        * ==================================================================*/
        $wp_customize->add_setting( 'primary_color',
            array(
                'default' => $this->defaults['primary_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'primary_color',
            array(
                'label' => esc_html__( 'Primary Color', 'staco' ),
                'section' => 'site_color_section',
                'type' => 'color',
            )
        );

        $wp_customize->add_setting( 'body_color',
            array(
                'default' => $this->defaults['body_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'body_color',
            array(
                'label' => esc_html__( 'Body Color', 'staco' ),
                'section' => 'site_color_section',
                'type' => 'color',
            )
        );

        /**
        * Transparent Color Controls
        * =================================================================*/
        $wp_customize->add_setting('menu_color_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control2($wp_customize, 'menu_color_heading', array(
            'label' => esc_html__( 'Menu Color', 'staco' ),
            'section' => 'menu_color_section',
        )));

        // Menu Text Color
        $wp_customize->add_setting( 'menu_text_color',
            array(
                'default' => $this->defaults['menu_text_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'menu_text_color',
            array(
                'label' => esc_html__( 'Normal Color', 'staco' ),
                'section' => 'menu_color_section',
                'type' => 'color',
                'default' => '#cac8c8',
            )
        );
        // Menu Text Hover Color
        $wp_customize->add_setting( 'menu_text_hover_color',
            array(
                'default' => $this->defaults['menu_text_hover_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'menu_text_hover_color',
            array(
                'label' => esc_html__( 'Hover Color', 'staco' ),
                'section' => 'menu_color_section',
                'type' => 'color',
                'default' => '#fff',
            )
        );

        /**
        * Sub Menu Color Controls
        * ======================================================================*/
        $wp_customize->add_setting('dropdown_menu_color_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control2($wp_customize, 'dropdown_menu_color_heading', array(
            'label' => esc_html__( 'Sub Menu Color', 'staco' ),
            'section' => 'menu_color_section',
        )));

        // Submenu BG Color
        $wp_customize->add_setting( 'submenu_bg_color',
            array(
                'default' => $this->defaults['submenu_bg_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'submenu_bg_color',
            array(
                'label' => esc_html__( 'Background Color', 'staco' ),
                'section' => 'menu_color_section',
                'type' => 'color',
                'default' => '#ffffff',
            )
        );

        // Submenu Text Color
        $wp_customize->add_setting( 'submenu_text_color',
            array(
                'default' => $this->defaults['submenu_text_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'submenu_text_color',
            array(
                'label' => esc_html__( 'Text Color', 'staco' ),
                'section' => 'menu_color_section',
                'type' => 'color',
                'default' => '#041A57',
            )
        );

         // Submenu Hover Text Color
        $wp_customize->add_setting( 'submenu_htext_color',
            array(
                'default' => $this->defaults['submenu_htext_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'submenu_htext_color',
            array(
                'label' => esc_html__( 'Hover Text Color', 'staco' ),
                'section' => 'menu_color_section',
                'type' => 'color',
                'default' => '',
            )
        );

        /**
        * Transparent Sticky Color Controls
        * ======================================================================*/
        $wp_customize->add_setting('sticky_menu_color_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control2($wp_customize, 'sticky_menu_color_heading', array(
            'label' => esc_html__( 'Sticky Menu Color', 'staco' ),
            'section' => 'menu_color_section',
        )));
        // Sticky BG Color
        $wp_customize->add_setting( 'sticky_menu_bg_color',
            array(
                'default' => $this->defaults['sticky_menu_bg_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'sticky_menu_bg_color',
            array(
                'label' => esc_html__( 'Background Color', 'staco' ),
                'section' => 'menu_color_section',
                'type' => 'color',
                'default' => '#ffffff',
            )
        );
        // Sticky Text Color
        $wp_customize->add_setting( 'sticky_menu_text_color',
            array(
                'default' => $this->defaults['sticky_menu_text_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'sticky_menu_text_color',
            array(
                'label' => esc_html__( 'Background Color', 'staco' ),
                'section' => 'menu_color_section',
                'type' => 'color',
                'default' => '#041A57',
            )
        );

        /**
        * Preloader Color Controls
        * ================================================================*/
        $wp_customize->add_setting('preloader_color_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control2($wp_customize, 'preloader_color_heading', array(
            'label' => esc_html__( 'Preloader Color', 'staco' ),
            'section' => 'others_color_section',
        )));
        // bg Color
        $wp_customize->add_setting( 'preloader_bg_color',
            array(
                'default' => $this->defaults['preloader_bg_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'preloader_bg_color',
            array(
                'label' => esc_html__( 'Background Color', 'staco' ),
                'section' => 'others_color_section',
                'type' => 'color',
            )
        );
        // Triangle 1 Color
        $wp_customize->add_setting( 'preloader_triangle_color1',
            array(
                'default' => $this->defaults['preloader_triangle_color1'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'preloader_triangle_color1',
            array(
                'label' => esc_html__( 'Triangle Color 1', 'staco' ),
                'section' => 'others_color_section',
                'type' => 'color',
            )
        );
        // Triangle 2 Color
        $wp_customize->add_setting( 'preloader_triangle_color2',
            array(
                'default' => $this->defaults['preloader_triangle_color2'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'preloader_triangle_color2',
            array(
                'label' => esc_html__( 'Triangle Color 2', 'staco' ),
                'section' => 'others_color_section',
                'type' => 'color',
            )
        );

        /**
        * Scroller Color Controls
        * ================================================================*/
        $wp_customize->add_setting('scrollup_color_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control2($wp_customize, 'scrollup_color_heading', array(
            'label' => esc_html__( 'Scroll Up Color', 'staco' ),
            'section' => 'others_color_section',
        )));

        $wp_customize->add_setting( 'scroll_bg_color',
            array(
                'default' => $this->defaults['scroll_bg_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'scroll_bg_color',
            array(
                'label' => esc_html__( 'Background Color', 'staco' ),
                'section' => 'others_color_section',
                'type' => 'color',
            )
        );
        $wp_customize->add_setting( 'scroll_color',
            array(
                'default' => $this->defaults['scroll_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'scroll_color',
            array(
                'label' => esc_html__( 'Icon Color', 'staco' ),
                'section' => 'others_color_section',
                'type' => 'color',
            )
        );

        /**
        * Transparent Sticky Color Controls 
        * ======================================================================*/
        // Page Background Color
        $wp_customize->add_setting( 'dark_page_bg_color',
            array(
                'default' => $this->defaults['dark_page_bg_color'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'dark_page_bg_color',
            array(
                'label' => esc_html__( 'Background Color', 'staco' ),
                'section' => 'dark_layout_color_section',
                'type' => 'color',
            )
        );
        // Background Image
        $wp_customize->add_setting( 'dark_page_bg_img',
            array(
                'default' => $this->defaults['dark_page_bg_img'],
                'transport' => 'refresh',
                'sanitize_callback' => 'absint',
            )
        );
        $wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'dark_page_bg_img',
            array(
                'label' => esc_html__( 'Page Background Image', 'staco' ),
                'description' => esc_html__( 'This is the description for the Media Control', 'staco' ),
                'section' => 'dark_layout_color_section',
                'mime_type' => 'image',
                'button_labels' => array(
                    'select' => esc_html__( 'Select File', 'staco' ),
                    'change' => esc_html__( 'Change File', 'staco' ),
                    'default' => esc_html__( 'Default', 'staco' ),
                    'remove' => esc_html__( 'Remove', 'staco' ),
                    'placeholder' => esc_html__( 'No file selected', 'staco' ),
                    'frame_title' => esc_html__( 'Select File', 'staco' ),
                    'frame_button' => esc_html__( 'Choose File', 'staco' ),
                )
            )
        ) );

    }

}

/**
 * Initialise our Customizer settings only when they're required  
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new staco_Colors_Settings();
}
