<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\staco\Customizer\Settings;

use UiGigs\staco\Customizer\staco_Customizer;
use UiGigs\staco\Customizer\Controls\Customizer_Switch_Control;
use UiGigs\staco\Customizer\Controls\Customizer_Gallery_Control;
use UiGigs\staco\Customizer\Controls\Customizer_Heading_Control;
use UiGigs\staco\Customizer\Controls\Customizer_Separator_Control;
use WP_Customize_Media_Control;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class staco_Contact_Settings extends staco_Customizer {

	public function __construct() {
        parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_general_controls' ) );
	}

    public function register_general_controls( $wp_customize ) {
        /**
         * Socials
         */
        $wp_customize->add_setting('socials_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'socials_heading', array(
            'label' => esc_html__( 'Socials', 'staco' ),
            'section' => 'contact_section',
        )));
        //Opensea
        $wp_customize->add_setting( 'social_opensea',
            array(
                'default' => $this->defaults['social_opensea'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'social_opensea',
            array(
                'label' => esc_html__( 'Opensea', 'staco' ),
                'section' => 'contact_section',
                'type' => 'text',
            )
        );
        // Facebook
        $wp_customize->add_setting( 'social_facebook',
            array(
                'default' => $this->defaults['social_facebook'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'social_facebook',
            array(
                'label' => esc_html__( 'Facebook', 'staco' ),
                'section' => 'contact_section',
                'type' => 'text',
            )
        );
        // Twitter
        $wp_customize->add_setting( 'social_twitter',
            array(
                'default' => $this->defaults['social_twitter'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'social_twitter',
            array(
                'label' => esc_html__( 'Twitter', 'staco' ),
                'section' => 'contact_section',
                'type' => 'text',
            )
        );
        // Discord
        $wp_customize->add_setting( 'social_discord',
            array(
                'default' => $this->defaults['social_discord'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'social_discord',
            array(
                'label' => esc_html__( 'Discord', 'staco' ),
                'section' => 'contact_section',
                'type' => 'text',
            )
        );
        // Pinterest
        $wp_customize->add_setting( 'social_pinterest',
            array(
                'default' => $this->defaults['social_pinterest'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'social_pinterest',
            array(
                'label' => esc_html__( 'Pinterest', 'staco' ),
                'section' => 'contact_section',
                'type' => 'text',
            )
        );
        // Instagram
        $wp_customize->add_setting( 'social_instagram',
            array(
                'default' => $this->defaults['social_instagram'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'social_instagram',
            array(
                'label' => esc_html__( 'Instagram', 'staco' ),
                'section' => 'contact_section',
                'type' => 'text',
            )
        );

    }

}

/**
 * Initialise our Customizer settings only when they're required  
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new staco_Contact_Settings();
}
