<?php
/**
 * @author  UiGigs
 * @since   1.0
 * @version 1.0
 */
namespace UiGigs\staco\Customizer\Settings;

use UiGigs\staco\Customizer\staco_Customizer;
use UiGigs\staco\Customizer\Controls\Customizer_Switch_Control;
use UiGigs\staco\Customizer\Controls\Customizer_Heading_Control;
use UiGigs\staco\Customizer\Controls\Customizer_Heading_Control2;
use UiGigs\staco\Customizer\Controls\Customizer_Image_Radio_Control;
use WP_Customize_Media_Control;
use WP_Customize_Color_Control;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class staco_Header_Settings extends staco_Customizer {

	public function __construct() {
	    parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_header_controls' ) );
	}
    public function register_header_controls( $wp_customize ) {

        // Add our Checkbox switch setting and control for opening URLs in a new tab
        $wp_customize->add_setting( 'header_area',
            array(
                'default' => $this->defaults['header_area'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'header_area',
            array(
                'label' => esc_html__( 'Header Area', 'staco' ),
                'section' => 'header_common',
            )
        ) );

        /**
         * Heading
         * ===================================================================================================*/
        $wp_customize->add_setting('header_switching', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'header_switching', array(
            'label' => esc_html__( 'Header Control', 'staco' ),
            'section' => 'header_common',
        )));

        // Add our Checkbox switch setting and control for opening URLs in a new tab
        $wp_customize->add_setting( 'header_sticky',
            array(
                'default' => $this->defaults['header_sticky'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'header_sticky',
            array(
                'label' => esc_html__( 'Header Sticky', 'staco' ),
                'section' => 'header_common',
            )
        ) );

        $wp_customize->add_setting( 'tr_header',
            array(
                'default' => $this->defaults['tr_header'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'tr_header',
            array(
                'label' => __( 'Transparent Header', 'staco' ),
                'section' => 'header_common',
            )
        ) );

        $wp_customize->add_setting( 'connect_btn_txt',
            array(
                'default' => $this->defaults['connect_btn_txt'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'connect_btn_txt',
            array(
                'label' => esc_html__( ' Connect Button Text', 'staco' ),
                'section' => 'header_common',
                'type' => 'text',
                'active_callback' => 'uigtheme_header_btn_enabled',
            )
        );

        // Header Socials
        $wp_customize->add_setting( 'header_social',
            array(
                'default' => $this->defaults['header_social'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'header_social',
            array(
                'label' => esc_html__( 'Socials', 'staco' ),
                'section' => 'header_common',
            )
        ) );

        // Header
        $wp_customize->add_setting( 'hbtn_txt',
            array(
                'default' => $this->defaults['hbtn_txt'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'hbtn_txt',
            array(
                'label' => esc_html__( ' Button Text', 'staco' ),
                'section' => 'header_common',
                'type' => 'text',
                'active_callback' => 'uigtheme_header_btn_enabled',
            )
        );
        $wp_customize->add_setting( 'hbtn_link',
            array(
                'default' => $this->defaults['hbtn_link'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'hbtn_link',
            array(
                'label' => esc_html__( 'Button Link', 'staco' ),
                'section' => 'header_common',
                'type' => 'text',
                'active_callback' => 'uigtheme_header_btn_enabled',
            )
        );

        /**
         * Socials
         */
        $wp_customize->add_setting('header_socials_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'header_socials_heading', array(
            'label' => esc_html__( 'Socials Link', 'staco' ),
            'section' => 'header_common',
        )));

        //Opensea
        $wp_customize->add_setting( 'hsocial_opensea',
            array(
                'default' => $this->defaults['hsocial_opensea'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'hsocial_opensea',
            array(
                'label' => esc_html__( 'Opensea', 'staco' ),
                'section' => 'header_common',
                'type' => 'text',
            )
        );
        // Twitter
        $wp_customize->add_setting( 'hsocial_twitter',
            array(
                'default' => $this->defaults['hsocial_twitter'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'hsocial_twitter',
            array(
                'label' => esc_html__( 'Twitter', 'staco' ),
                'section' => 'header_common',
                'type' => 'text',
            )
        );
        // Discord
        $wp_customize->add_setting( 'hsocial_discord',
            array(
                'default' => $this->defaults['hsocial_discord'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'hsocial_discord',
            array(
                'label' => esc_html__( 'Discord', 'staco' ),
                'section' => 'header_common',
                'type' => 'text',
            )
        );
        // Facebook
        $wp_customize->add_setting( 'hsocial_facebook',
            array(
                'default' => $this->defaults['hsocial_facebook'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'hsocial_facebook',
            array(
                'label' => esc_html__( 'Facebook', 'staco' ),
                'section' => 'header_common',
                'type' => 'text',
            )
        );

        /**
         * Mobile Devices Menu Heading
        * ===================================================================================================*/
        $wp_customize->add_setting('mobile_header_switching', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'mobile_header_switching', array(
            'label' => esc_html__( 'Mobile Menu Control', 'staco' ),
            'section' => 'header_mobile_section',
        )));

        // Mobile Devices Search
        $wp_customize->add_setting( 'mobile_social',
            array(
                'default' => $this->defaults['mobile_social'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'mobile_social',
            array(
                'label' => esc_html__( 'Social Button', 'staco' ),
                'section' => 'header_mobile_section',
            )
        ) );
        // Mobile Devices Button
        $wp_customize->add_setting( 'mobile_link',
            array(
                'default' => $this->defaults['mobile_link'],
                'transport' => 'refresh',
                'sanitize_callback' => 'uigtheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'mobile_link',
            array(
                'label' => esc_html__( 'Link Button', 'staco' ),
                'section' => 'header_mobile_section',
            )
        ) );

    }
}

/**
 * Initialise our Customizer settings only when they're required
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new staco_Header_Settings();
}
